@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property labels The label of the time dimension.
 * @property metricName The name of the monitoring indicator.
 * @property values The metric values that are collected at different timestamps.
 */
public data class GetHybridMonitorDatasData(
    public val labels: List<GetHybridMonitorDatasDataLabel>,
    public val metricName: String,
    public val values: List<GetHybridMonitorDatasDataValue>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetHybridMonitorDatasData): GetHybridMonitorDatasData = GetHybridMonitorDatasData(
            labels = javaType.labels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorDatasDataLabel.Companion.toKotlin(args0)
                })
            }),
            metricName = javaType.metricName(),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorDatasDataValue.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
