@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHybridMonitorDatas.
 * @property datas
 * @property end
 * @property id The provider-assigned unique ID for this managed resource.
 * @property namespace
 * @property outputFile
 * @property period
 * @property promSql
 * @property start
 */
public data class GetHybridMonitorDatasResult(
    public val datas: List<GetHybridMonitorDatasData>,
    public val end: String,
    public val id: String,
    public val namespace: String,
    public val outputFile: String? = null,
    public val period: String? = null,
    public val promSql: String,
    public val start: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetHybridMonitorDatasResult): GetHybridMonitorDatasResult = GetHybridMonitorDatasResult(
            datas = javaType.datas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorDatasData.Companion.toKotlin(args0)
                })
            }),
            end = javaType.end(),
            id = javaType.id(),
            namespace = javaType.namespace(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            period = javaType.period().map({ args0 -> args0 }).orElse(null),
            promSql = javaType.promSql(),
            start = javaType.start(),
        )
    }
}
