@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHybridMonitorFcTasks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property namespace
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property tasks
 */
public data class GetHybridMonitorFcTasksResult(
    public val id: String,
    public val ids: List<String>,
    public val namespace: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val tasks: List<GetHybridMonitorFcTasksTask>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetHybridMonitorFcTasksResult): GetHybridMonitorFcTasksResult = GetHybridMonitorFcTasksResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            tasks = javaType.tasks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorFcTasksTask.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
