@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime Create the timestamp of the monitoring task. Unit: milliseconds.
 * @property hybridMonitorFcTaskId The ID of the monitoring task.
 * @property id The ID of the Hybrid Monitor Fc Task. The value formats as `<hybrid_monitor_fc_task_id>:<namespace>`.
 * @property namespace The index warehouse where the host belongs.
 * @property targetUserId The ID of the member account.
 * @property yarmConfig The configuration file of the Alibaba Cloud service that you want to monitor by using Hybrid Cloud Monitoring.
 */
public data class GetHybridMonitorFcTasksTask(
    public val createTime: String,
    public val hybridMonitorFcTaskId: String,
    public val id: String,
    public val namespace: String,
    public val targetUserId: String,
    public val yarmConfig: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetHybridMonitorFcTasksTask): GetHybridMonitorFcTasksTask = GetHybridMonitorFcTasksTask(
            createTime = javaType.createTime(),
            hybridMonitorFcTaskId = javaType.hybridMonitorFcTaskId(),
            id = javaType.id(),
            namespace = javaType.namespace(),
            targetUserId = javaType.targetUserId(),
            yarmConfig = javaType.yarmConfig(),
        )
    }
}
