@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHybridMonitorSlsTasks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyword
 * @property namespace
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property tasks
 */
public data class GetHybridMonitorSlsTasksResult(
    public val id: String,
    public val ids: List<String>,
    public val keyword: String? = null,
    public val namespace: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val tasks: List<GetHybridMonitorSlsTasksTask>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetHybridMonitorSlsTasksResult): GetHybridMonitorSlsTasksResult = GetHybridMonitorSlsTasksResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyword = javaType.keyword().map({ args0 -> args0 }).orElse(null),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            tasks = javaType.tasks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksTask.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
