@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attachLabels The tags of the metric import task.
 * @property collectInterval The interval between the cloud monitoring plug-in collecting host monitoring data.
 * @property collectTargetEndpoint The address where the cloudmonitor Plug-In collects the monitoring data of the host.
 * @property collectTargetPath When the cloud monitor Agent collects, the relative path of the collection.
 * @property collectTargetType The type of the monitoring data. Valid values: Spring, Tomcat, Nginx, Tengine, JVM, Redis, MySQL, and AWS.
 * @property collectTimout The timeout period for the cloudmonitor plug-in to collect host monitoring data.
 * @property createTime Create the timestamp of the monitoring task. Unit: milliseconds.
 * @property description Monitoring task description.
 * @property extraInfo Additional information for the instance.
 * @property groupId The ID of the application Group.
 * @property hybridMonitorSlsTaskId The ID of the monitoring task.
 * @property id The ID of the Hybrid Monitor Sls Task.
 * @property instances A list of instances where monitoring data is collected in batches.
 * @property logFilePath The path where on-premises log data is stored. On-premises log data is stored in the specified path of the host where CloudMonitor is deployed.
 * @property logProcess Local Log Monitoring and calculation method.
 * @property logSample The sample on-premises log.
 * @property logSplit The local log data is divided according to different matching patterns.
 * @property matchExpressRelation The filter condition of the instance of the monitoring task.
 * @property matchExpresses The matching condition of the instance in the application Group.
 * @property namespace The namespace to which the host belongs.
 * @property networkType The network type of the host.
 * @property slsProcess The configurations of the logs that are imported from Log Service.
 * @property slsProcessConfigs The configurations of the logs that are imported from Log Service.
 * @property taskName The name of the metric import task.
 * @property taskType Monitoring Task type.
 * @property uploadRegion The region where the host resides.
 * @property yarmConfig
 */
public data class GetHybridMonitorSlsTasksTask(
    public val attachLabels: List<GetHybridMonitorSlsTasksTaskAttachLabel>,
    public val collectInterval: Int,
    public val collectTargetEndpoint: String,
    public val collectTargetPath: String,
    public val collectTargetType: String,
    public val collectTimout: Int,
    public val createTime: String,
    public val description: String,
    public val extraInfo: String,
    public val groupId: String,
    public val hybridMonitorSlsTaskId: String,
    public val id: String,
    public val instances: List<String>,
    public val logFilePath: String,
    public val logProcess: String,
    public val logSample: String,
    public val logSplit: String,
    public val matchExpressRelation: String,
    public val matchExpresses: List<GetHybridMonitorSlsTasksTaskMatchExpress>,
    public val namespace: String,
    public val networkType: String,
    public val slsProcess: String,
    public val slsProcessConfigs: List<GetHybridMonitorSlsTasksTaskSlsProcessConfig>,
    public val taskName: String,
    public val taskType: String,
    public val uploadRegion: String,
    public val yarmConfig: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetHybridMonitorSlsTasksTask): GetHybridMonitorSlsTasksTask = GetHybridMonitorSlsTasksTask(
            attachLabels = javaType.attachLabels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksTaskAttachLabel.Companion.toKotlin(args0)
                })
            }),
            collectInterval = javaType.collectInterval(),
            collectTargetEndpoint = javaType.collectTargetEndpoint(),
            collectTargetPath = javaType.collectTargetPath(),
            collectTargetType = javaType.collectTargetType(),
            collectTimout = javaType.collectTimout(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            extraInfo = javaType.extraInfo(),
            groupId = javaType.groupId(),
            hybridMonitorSlsTaskId = javaType.hybridMonitorSlsTaskId(),
            id = javaType.id(),
            instances = javaType.instances().map({ args0 -> args0 }),
            logFilePath = javaType.logFilePath(),
            logProcess = javaType.logProcess(),
            logSample = javaType.logSample(),
            logSplit = javaType.logSplit(),
            matchExpressRelation = javaType.matchExpressRelation(),
            matchExpresses = javaType.matchExpresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksTaskMatchExpress.Companion.toKotlin(args0)
                })
            }),
            namespace = javaType.namespace(),
            networkType = javaType.networkType(),
            slsProcess = javaType.slsProcess(),
            slsProcessConfigs = javaType.slsProcessConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksTaskSlsProcessConfig.Companion.toKotlin(args0)
                })
            }),
            taskName = javaType.taskName(),
            taskType = javaType.taskType(),
            uploadRegion = javaType.uploadRegion(),
            yarmConfig = javaType.yarmConfig(),
        )
    }
}
