@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property expresses
 * @property filters The conditions that are used to filter logs imported from Log Service.
 * @property groupBies The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL.
 * @property statistics The method that is used to aggregate logs imported from Log Service.
 */
public data class GetHybridMonitorSlsTasksTaskSlsProcessConfig(
    public val expresses: List<GetHybridMonitorSlsTasksTaskSlsProcessConfigExpress>,
    public val filters: List<GetHybridMonitorSlsTasksTaskSlsProcessConfigFilter>,
    public val groupBies: List<GetHybridMonitorSlsTasksTaskSlsProcessConfigGroupBy>,
    public val statistics: List<GetHybridMonitorSlsTasksTaskSlsProcessConfigStatistic>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetHybridMonitorSlsTasksTaskSlsProcessConfig): GetHybridMonitorSlsTasksTaskSlsProcessConfig = GetHybridMonitorSlsTasksTaskSlsProcessConfig(
            expresses = javaType.expresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksTaskSlsProcessConfigExpress.Companion.toKotlin(args0)
                })
            }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksTaskSlsProcessConfigFilter.Companion.toKotlin(args0)
                })
            }),
            groupBies = javaType.groupBies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksTaskSlsProcessConfigGroupBy.Companion.toKotlin(args0)
                })
            }),
            statistics = javaType.statistics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetHybridMonitorSlsTasksTaskSlsProcessConfigStatistic.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
