@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property category Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
 * @property createTime The timestamp for creating an alert blacklist policy.Unit: milliseconds.
 * @property effectiveTime The effective time range of the alert blacklist policy.
 * @property enableEndTime The start timestamp of the alert blacklist policy.Unit: milliseconds.
 * @property enableStartTime The end timestamp of the alert blacklist policy.Unit: milliseconds.
 * @property id
 * @property instances The list of instances of cloud services specified in the alert blacklist policy.
 * @property isEnable The status of the alert blacklist policy. Value:-true: enabled.-false: disabled.
 * @property metricRuleBlackListId The first ID of the resource
 * @property metricRuleBlackListName The name of the alert blacklist policy.
 * @property metrics Monitoring metrics in the instance.
 * @property namespace The data namespace of the cloud service.
 * @property scopeType The effective range of the alert blacklist policy. Value:-USER: The alert blacklist policy only takes effect in the current Alibaba cloud account.-GROUP: The alert blacklist policy takes effect in the specified application GROUP.
 * @property scopeValues Application Group ID list. The format is JSON Array.> This parameter is displayed only when 'ScopeType' is 'GROUP.
 */
public data class GetMetricRuleBlackListsList(
    public val category: String,
    public val createTime: String,
    public val effectiveTime: String,
    public val enableEndTime: String,
    public val enableStartTime: String,
    public val id: String,
    public val instances: List<String>,
    public val isEnable: Boolean,
    public val metricRuleBlackListId: String,
    public val metricRuleBlackListName: String,
    public val metrics: List<GetMetricRuleBlackListsListMetric>,
    public val namespace: String,
    public val scopeType: String,
    public val scopeValues: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMetricRuleBlackListsList): GetMetricRuleBlackListsList = GetMetricRuleBlackListsList(
            category = javaType.category(),
            createTime = javaType.createTime(),
            effectiveTime = javaType.effectiveTime(),
            enableEndTime = javaType.enableEndTime(),
            enableStartTime = javaType.enableStartTime(),
            id = javaType.id(),
            instances = javaType.instances().map({ args0 -> args0 }),
            isEnable = javaType.isEnable(),
            metricRuleBlackListId = javaType.metricRuleBlackListId(),
            metricRuleBlackListName = javaType.metricRuleBlackListName(),
            metrics = javaType.metrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetMetricRuleBlackListsListMetric.Companion.toKotlin(args0)
                })
            }),
            namespace = javaType.namespace(),
            scopeType = javaType.scopeType(),
            scopeValues = javaType.scopeValues().map({ args0 -> args0 }),
        )
    }
}
