@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metricName The name of the monitoring indicator.
 * @property resource The extended dimension information of the instance. For example, '{"device":"C:"}' indicates that the blacklist policy is applied to all C disks under the ECS instance.
 */
public data class GetMetricRuleBlackListsListMetric(
    public val metricName: String,
    public val resource: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMetricRuleBlackListsListMetric): GetMetricRuleBlackListsListMetric = GetMetricRuleBlackListsListMetric(
            metricName = javaType.metricName(),
            resource = javaType.resource(),
        )
    }
}
