@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMetricRuleBlackLists.
 * @property category Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Metric Rule Black List IDs.
 * @property lists A list of Metric Rule Black List Entries. Each element contains the following attributes:
 * @property metricRuleBlackListId The first ID of the resource
 * @property nameRegex
 * @property names A list of name of Metric Rule Black Lists.
 * @property namespace The data namespace of the cloud service.
 * @property order
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetMetricRuleBlackListsResult(
    public val category: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val lists: List<GetMetricRuleBlackListsList>,
    public val metricRuleBlackListId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val namespace: String? = null,
    public val order: Int? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMetricRuleBlackListsResult): GetMetricRuleBlackListsResult = GetMetricRuleBlackListsResult(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            lists = javaType.lists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetMetricRuleBlackListsList.Companion.toKotlin(args0)
                })
            }),
            metricRuleBlackListId = javaType.metricRuleBlackListId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            order = javaType.order().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
