@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMetricRuleTemplates.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyword
 * @property metricRuleTemplateName
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property templateId
 * @property templates
 */
public data class GetMetricRuleTemplatesResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val keyword: String? = null,
    public val metricRuleTemplateName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val templateId: String? = null,
    public val templates: List<GetMetricRuleTemplatesTemplate>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMetricRuleTemplatesResult): GetMetricRuleTemplatesResult = GetMetricRuleTemplatesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyword = javaType.keyword().map({ args0 -> args0 }).orElse(null),
            metricRuleTemplateName = javaType.metricRuleTemplateName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            templateId = javaType.templateId().map({ args0 -> args0 }).orElse(null),
            templates = javaType.templates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetMetricRuleTemplatesTemplate.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
