@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alertTemplates The details of alert rules that are generated based on the alert template.
 * @property description The description of the alert template.
 * @property groupId GroupId.
 * @property id The ID of the Metric Rule Template.
 * @property metricRuleTemplateName The name of the alert template.
 * @property restVersion The version of the alert template.
 * > **NOTE:** The version changes with the number of times that the alert template is modified.
 * @property templateId The ID of the alert template.
 */
public data class GetMetricRuleTemplatesTemplate(
    public val alertTemplates: List<GetMetricRuleTemplatesTemplateAlertTemplate>,
    public val description: String,
    public val groupId: String,
    public val id: String,
    public val metricRuleTemplateName: String,
    public val restVersion: String,
    public val templateId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMetricRuleTemplatesTemplate): GetMetricRuleTemplatesTemplate = GetMetricRuleTemplatesTemplate(
            alertTemplates = javaType.alertTemplates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetMetricRuleTemplatesTemplateAlertTemplate.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            groupId = javaType.groupId(),
            id = javaType.id(),
            metricRuleTemplateName = javaType.metricRuleTemplateName(),
            restVersion = javaType.restVersion(),
            templateId = javaType.templateId(),
        )
    }
}
