@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property category The abbreviation of the service name. Valid values: `ecs`, `rds`, `ads`, `slb`, `vpc`, `apigateway`, `cdn`, `cs`, `dcdn`, `ddos`, `eip`, `elasticsearch`, `emr`, `ess`, `hbase`, `iot_edge`, `kvstore_sharding`, `kvstore_splitrw`, `kvstore_standard`, `memcache`, `mns`, `mongodb`, `mongodb_cluster`, `mongodb_sharding`, `mq_topic`, `ocs`, `opensearch`, `oss`, `polardb`, `petadata`, `scdn`, `sharebandwidthpackages`, `sls`, `vpn`.
 * @property escalations The information about the trigger condition based on the alert level.
 * @property metricName The name of the metric.
 * @property namespace The namespace of the service.
 * @property ruleName The name of the alert rule.
 * @property selector
 * @property webhook The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
 */
public data class GetMetricRuleTemplatesTemplateAlertTemplate(
    public val category: String,
    public val escalations: List<GetMetricRuleTemplatesTemplateAlertTemplateEscalation>,
    public val metricName: String,
    public val namespace: String,
    public val ruleName: String,
    public val selector: String,
    public val webhook: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMetricRuleTemplatesTemplateAlertTemplate): GetMetricRuleTemplatesTemplateAlertTemplate = GetMetricRuleTemplatesTemplateAlertTemplate(
            category = javaType.category(),
            escalations = javaType.escalations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetMetricRuleTemplatesTemplateAlertTemplateEscalation.Companion.toKotlin(args0)
                })
            }),
            metricName = javaType.metricName(),
            namespace = javaType.namespace(),
            ruleName = javaType.ruleName(),
            selector = javaType.selector(),
            webhook = javaType.webhook(),
        )
    }
}
