@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comparisonOperator The comparison operator of the threshold for critical-level alerts.Valid values: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanOrEqualToThreshold`, `LessThanThreshold`, `NotEqualToThreshold`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`.
 * @property statistics The statistical aggregation method for critical-level alerts.
 * @property threshold The threshold for critical-level alerts.
 * @property times The consecutive number of times for which the metric value is measured before a
 * critical-level alert is triggered.
 */
public data class GetMetricRuleTemplatesTemplateAlertTemplateEscalationCritical(
    public val comparisonOperator: String,
    public val statistics: String,
    public val threshold: String,
    public val times: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMetricRuleTemplatesTemplateAlertTemplateEscalationCritical): GetMetricRuleTemplatesTemplateAlertTemplateEscalationCritical =
            GetMetricRuleTemplatesTemplateAlertTemplateEscalationCritical(
                comparisonOperator = javaType.comparisonOperator(),
                statistics = javaType.statistics(),
                threshold = javaType.threshold(),
                times = javaType.times(),
            )
    }
}
