@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMonitorGroupInstances.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instances
 * @property keyword
 * @property outputFile
 */
public data class GetMonitorGroupInstancesResult(
    public val id: String,
    public val ids: String,
    public val instances: List<GetMonitorGroupInstancesInstance>,
    public val keyword: String? = null,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMonitorGroupInstancesResult): GetMonitorGroupInstancesResult = GetMonitorGroupInstancesResult(
            id = javaType.id(),
            ids = javaType.ids(),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetMonitorGroupInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            keyword = javaType.keyword().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
