@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property bindUrl The URL of the Kubernetes cluster from which the application group is synchronized.
 * @property contactGroups The list of  alert groups that receive alert notifications for the application group.
 * @property dynamicTagRuleId The ID of the tag rule.
 * @property gmtCreate The time when the application group was created.
 * @property gmtModified The time when the application group was modified.
 * @property groupId The ID of the application group.
 * @property id The ID of the Monitor Group.
 * @property monitorGroupName The name of the application group.
 * @property serviceId The ID of the Alibaba Cloud service.
 * @property tags A map of tags assigned to the Cms Monitor Group.
 * @property templateIds The alert templates applied to the application group.
 * @property type The type of the application group.
 */
public data class GetMonitorGroupsGroup(
    public val bindUrl: String,
    public val contactGroups: List<String>,
    public val dynamicTagRuleId: String,
    public val gmtCreate: Int,
    public val gmtModified: Int,
    public val groupId: String,
    public val id: String,
    public val monitorGroupName: String,
    public val serviceId: String,
    public val tags: Map<String, String>,
    public val templateIds: List<String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMonitorGroupsGroup): GetMonitorGroupsGroup = GetMonitorGroupsGroup(
            bindUrl = javaType.bindUrl(),
            contactGroups = javaType.contactGroups().map({ args0 -> args0 }),
            dynamicTagRuleId = javaType.dynamicTagRuleId(),
            gmtCreate = javaType.gmtCreate(),
            gmtModified = javaType.gmtModified(),
            groupId = javaType.groupId(),
            id = javaType.id(),
            monitorGroupName = javaType.monitorGroupName(),
            serviceId = javaType.serviceId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateIds = javaType.templateIds().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
