@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getMonitorGroups.
 * @property dynamicTagRuleId
 * @property groups
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property includeTemplateHistory
 * @property keyword
 * @property monitorGroupName
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property selectContactGroups
 * @property tags
 * @property type
 */
public data class GetMonitorGroupsResult(
    public val dynamicTagRuleId: String? = null,
    public val groups: List<GetMonitorGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val includeTemplateHistory: Boolean? = null,
    public val keyword: String? = null,
    public val monitorGroupName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val selectContactGroups: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetMonitorGroupsResult): GetMonitorGroupsResult = GetMonitorGroupsResult(
            dynamicTagRuleId = javaType.dynamicTagRuleId().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetMonitorGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeTemplateHistory = javaType.includeTemplateHistory().map({ args0 -> args0 }).orElse(null),
            keyword = javaType.keyword().map({ args0 -> args0 }).orElse(null),
            monitorGroupName = javaType.monitorGroupName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            selectContactGroups = javaType.selectContactGroups().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
