@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime Create the timestamp of the indicator warehouse.
 * @property description Description of indicator warehouse.
 * @property id The ID of the Namespace.
 * @property modifyTime The timestamp of the last modification indicator warehouse.
 * @property namespace Indicator warehouse name.
 * @property namespaceId The ID of the Namespace.
 * @property specification Data storage duration.
 */
public data class GetNamespacesNamespace(
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val modifyTime: String,
    public val namespace: String,
    public val namespaceId: String,
    public val specification: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetNamespacesNamespace): GetNamespacesNamespace = GetNamespacesNamespace(
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            modifyTime = javaType.modifyTime(),
            namespace = javaType.namespace(),
            namespaceId = javaType.namespaceId(),
            specification = javaType.specification(),
        )
    }
}
