@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNamespaces.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyword
 * @property namespaces
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetNamespacesResult(
    public val id: String,
    public val ids: List<String>,
    public val keyword: String? = null,
    public val namespaces: List<GetNamespacesNamespace>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetNamespacesResult): GetNamespacesResult = GetNamespacesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyword = javaType.keyword().map({ args0 -> args0 }).orElse(null),
            namespaces = javaType.namespaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetNamespacesNamespace.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
