@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSiteMonitors.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Site Monitor IDs.
 * @property monitors A list of Site Monitor Entries. Each element contains the following attributes:
 * @property outputFile
 * @property taskId Task Id.
 * @property taskType Task Type.
 */
public data class GetSiteMonitorsResult(
    public val id: String,
    public val ids: List<String>,
    public val monitors: List<GetSiteMonitorsMonitor>,
    public val outputFile: String? = null,
    public val taskId: String? = null,
    public val taskType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetSiteMonitorsResult): GetSiteMonitorsResult = GetSiteMonitorsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            monitors = javaType.monitors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetSiteMonitorsMonitor.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            taskId = javaType.taskId().map({ args0 -> args0 }).orElse(null),
            taskType = javaType.taskType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
