@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The creation time of the resource.
 * @property id The ID of the Sls Group. Its value is same as Queue Name.
 * @property slsGroupConfigs The Config of the Sls Group.
 * @property slsGroupDescription The Description of the Sls Group.
 * @property slsGroupName The name of the resource.
 */
public data class GetSlsGroupsGroup(
    public val createTime: String,
    public val id: String,
    public val slsGroupConfigs: List<GetSlsGroupsGroupSlsGroupConfig>,
    public val slsGroupDescription: String,
    public val slsGroupName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetSlsGroupsGroup): GetSlsGroupsGroup = GetSlsGroupsGroup(
            createTime = javaType.createTime(),
            id = javaType.id(),
            slsGroupConfigs = javaType.slsGroupConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetSlsGroupsGroupSlsGroupConfig.Companion.toKotlin(args0)
                })
            }),
            slsGroupDescription = javaType.slsGroupDescription(),
            slsGroupName = javaType.slsGroupName(),
        )
    }
}
