@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comparisonOperator The comparison operator of the threshold for warn-level alerts.
 * @property statistics The statistical aggregation method for warn-level alerts.
 * @property threshold The threshold for warn-level alerts.
 * @property times The consecutive number of times for which the metric value is measured before a warn-level alert is triggered.
 */
public data class GroupMetricRuleEscalationsInfo(
    public val comparisonOperator: String? = null,
    public val statistics: String? = null,
    public val threshold: String? = null,
    public val times: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GroupMetricRuleEscalationsInfo): GroupMetricRuleEscalationsInfo = GroupMetricRuleEscalationsInfo(
            comparisonOperator = javaType.comparisonOperator().map({ args0 -> args0 }).orElse(null),
            statistics = javaType.statistics().map({ args0 -> args0 }).orElse(null),
            threshold = javaType.threshold().map({ args0 -> args0 }).orElse(null),
            times = javaType.times().map({ args0 -> args0 }).orElse(null),
        )
    }
}
