@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Alibaba Cloud Resource Name (ARN) of the resource.
 * > **NOTE:** Currently, the Alibaba Cloud Resource Name (ARN) of the resource. To use, please [submit an application](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruletargets).
 * @property id The ID of the resource for which alerts are triggered.
 * @property jsonParams The parameters of the alert callback. The parameters are in the JSON format.
 * @property level The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
 */
public data class GroupMetricRuleTarget(
    public val arn: String? = null,
    public val id: String? = null,
    public val jsonParams: String? = null,
    public val level: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GroupMetricRuleTarget): GroupMetricRuleTarget = GroupMetricRuleTarget(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            jsonParams = javaType.jsonParams().map({ args0 -> args0 }).orElse(null),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
        )
    }
}
