@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property expresses The extended field that specifies the result of basic operations that are performed on aggregation results.
 * @property filter The conditions that are used to filter logs imported from Log Service. See `filter` below.
 * @property groupBies The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. See `group_by` below.
 * @property statistics The method that is used to aggregate logs imported from Log Service. See `statistics` below.
 */
public data class HybridMonitorSlsTaskSlsProcessConfig(
    public val expresses: List<HybridMonitorSlsTaskSlsProcessConfigExpress>? = null,
    public val filter: HybridMonitorSlsTaskSlsProcessConfigFilter? = null,
    public val groupBies: List<HybridMonitorSlsTaskSlsProcessConfigGroupBy>? = null,
    public val statistics: List<HybridMonitorSlsTaskSlsProcessConfigStatistic>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.HybridMonitorSlsTaskSlsProcessConfig): HybridMonitorSlsTaskSlsProcessConfig = HybridMonitorSlsTaskSlsProcessConfig(
            expresses = javaType.expresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.HybridMonitorSlsTaskSlsProcessConfigExpress.Companion.toKotlin(args0)
                })
            }),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.HybridMonitorSlsTaskSlsProcessConfigFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            groupBies = javaType.groupBies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.HybridMonitorSlsTaskSlsProcessConfigGroupBy.Companion.toKotlin(args0)
                })
            }),
            statistics = javaType.statistics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.HybridMonitorSlsTaskSlsProcessConfigStatistic.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
