@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alias The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
 * @property function The function that is used to aggregate log data within a statistical period. Valid values: `count`, `sum`, `avg`, `max`, `min`, `value`, `countps`, `sumps`, `distinct`, `distribution`, `percentile`.
 * @property parameterOne The value of the function that is used to aggregate logs imported from Log Service.
 * - If you set the `function` parameter to `distribution`, this parameter specifies the lower limit of the statistical interval. For example, if you want to calculate the number of HTTP requests whose status code is 2XX, set this parameter to 200.
 * - If you set the `function` parameter to `percentile`, this parameter specifies the percentile at which the expected value is. For example, 0.5 specifies P50.
 * @property parameterTwo The value of the function that is used to aggregate logs imported from Log Service. **Note:** This parameter is required only if the `function` parameter is set to `distribution`. This parameter specifies the upper limit of the statistical interval.
 * @property slsKeyName The name of the key that is used to filter logs imported from Log Service.
 */
public data class HybridMonitorSlsTaskSlsProcessConfigStatistic(
    public val alias: String? = null,
    public val function: String? = null,
    public val parameterOne: String? = null,
    public val parameterTwo: String? = null,
    public val slsKeyName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.HybridMonitorSlsTaskSlsProcessConfigStatistic): HybridMonitorSlsTaskSlsProcessConfigStatistic =
            HybridMonitorSlsTaskSlsProcessConfigStatistic(
                alias = javaType.alias().map({ args0 -> args0 }).orElse(null),
                function = javaType.function().map({ args0 -> args0 }).orElse(null),
                parameterOne = javaType.parameterOne().map({ args0 -> args0 }).orElse(null),
                parameterTwo = javaType.parameterTwo().map({ args0 -> args0 }).orElse(null),
                slsKeyName = javaType.slsKeyName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
