@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The abbreviation of the Alibaba Cloud service name.
 * > **NOTE:** To obtain the abbreviation of an Alibaba Cloud service name, call the [DescribeProjectMeta](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-describeprojectmeta) operation. The metricCategory tag in the Labels response parameter indicates the abbreviation of the Alibaba Cloud service name.
 * @property escalations The information about the trigger condition based on the alert level. See `escalations` below.
 * @property metricName The name of the metric.
 * > **NOTE:** For more information, see [DescribeMetricMetaList](https://www&#46;alibabacloud&#46;com/help/doc-detail/98846&#46;htm) or [Appendix 1: Metrics](https://www.alibabacloud.com/help/doc-detail/28619.htm).
 * @property namespace The namespace of the cloud service.
 * > **NOTE:** For more information, see [DescribeMetricMetaList](https://www&#46;alibabacloud&#46;com/help/doc-detail/98846&#46;htm) or [Appendix 1: Metrics](https://www.alibabacloud.com/help/doc-detail/28619.htm).
 * @property ruleName The name of the alert rule.
 * @property webhook The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
 */
public data class MetricRuleTemplateAlertTemplate(
    public val category: String,
    public val escalations: MetricRuleTemplateAlertTemplateEscalations? = null,
    public val metricName: String,
    public val namespace: String,
    public val ruleName: String,
    public val webhook: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.MetricRuleTemplateAlertTemplate): MetricRuleTemplateAlertTemplate = MetricRuleTemplateAlertTemplate(
            category = javaType.category(),
            escalations = javaType.escalations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.MetricRuleTemplateAlertTemplateEscalations.Companion.toKotlin(args0)
                })
            }).orElse(null),
            metricName = javaType.metricName(),
            namespace = javaType.namespace(),
            ruleName = javaType.ruleName(),
            webhook = javaType.webhook().map({ args0 -> args0 }).orElse(null),
        )
    }
}
