@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The category of instance.
 * @property instanceId The id of instance.
 * @property instanceName The name of instance.
 * @property regionId The region id of instance.
 */
public data class MonitorGroupInstancesInstance(
    public val category: String,
    public val instanceId: String,
    public val instanceName: String,
    public val regionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.MonitorGroupInstancesInstance): MonitorGroupInstancesInstance = MonitorGroupInstancesInstance(
            category = javaType.category(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            regionId = javaType.regionId(),
        )
    }
}
