@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property slsLogstore The name of the Log Store.
 * @property slsProject The name of the Project.
 * @property slsRegion The Sls Region.
 * @property slsUserId The ID of the Sls User.
 */
public data class SlsGroupSlsGroupConfig(
    public val slsLogstore: String,
    public val slsProject: String,
    public val slsRegion: String,
    public val slsUserId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.SlsGroupSlsGroupConfig): SlsGroupSlsGroupConfig = SlsGroupSlsGroupConfig(
            slsLogstore = javaType.slsLogstore(),
            slsProject = javaType.slsProject(),
            slsRegion = javaType.slsRegion(),
            slsUserId = javaType.slsUserId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
