@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.compute.kotlin

import com.pulumi.alicloud.compute.ComputeFunctions.getNestServiceInstancesPlain
import com.pulumi.alicloud.compute.kotlin.inputs.GetNestServiceInstancesFilter
import com.pulumi.alicloud.compute.kotlin.inputs.GetNestServiceInstancesPlainArgs
import com.pulumi.alicloud.compute.kotlin.inputs.GetNestServiceInstancesPlainArgsBuilder
import com.pulumi.alicloud.compute.kotlin.outputs.GetNestServiceInstancesResult
import com.pulumi.alicloud.compute.kotlin.outputs.GetNestServiceInstancesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

public object ComputeFunctions {
    /**
     * This data source provides the Compute Nest Service Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.205.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.compute.getNestServiceInstances({
     *     ids: ["example_id"],
     * });
     * export const armsPrometheisId1 = ids.then(ids => ids.serviceInstances?.[0]?.id);
     * const nameRegex = alicloud.compute.getNestServiceInstances({
     *     nameRegex: "tf-example",
     * });
     * export const armsPrometheisId2 = nameRegex.then(nameRegex => nameRegex.serviceInstances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.compute.get_nest_service_instances(ids=["example_id"])
     * pulumi.export("armsPrometheisId1", ids.service_instances[0].id)
     * name_regex = alicloud.compute.get_nest_service_instances(name_regex="tf-example")
     * pulumi.export("armsPrometheisId2", name_regex.service_instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Compute.GetNestServiceInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Compute.GetNestServiceInstances.Invoke(new()
     *     {
     *         NameRegex = "tf-example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["armsPrometheisId1"] = ids&#46;Apply(getNestServiceInstancesResult => getNestServiceInstancesResult&#46;ServiceInstances[0]?.Id),
     *         ["armsPrometheisId2"] = nameRegex&#46;Apply(getNestServiceInstancesResult => getNestServiceInstancesResult&#46;ServiceInstances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/compute"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := compute.GetNestServiceInstances(ctx, &compute.GetNestServiceInstancesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsPrometheisId1", ids.ServiceInstances[0].Id)
     * 		nameRegex, err := compute.GetNestServiceInstances(ctx, &compute.GetNestServiceInstancesArgs{
     * 			NameRegex: pulumi.StringRef("tf-example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("armsPrometheisId2", nameRegex.ServiceInstances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.compute.ComputeFunctions;
     * import com.pulumi.alicloud.compute.inputs.GetNestServiceInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ComputeFunctions.getNestServiceInstances(GetNestServiceInstancesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("armsPrometheisId1", ids.applyValue(getNestServiceInstancesResult -> getNestServiceInstancesResult.serviceInstances()[0].id()));
     *         final var nameRegex = ComputeFunctions.getNestServiceInstances(GetNestServiceInstancesArgs.builder()
     *             .nameRegex("tf-example")
     *             .build());
     *         ctx.export("armsPrometheisId2", nameRegex.applyValue(getNestServiceInstancesResult -> getNestServiceInstancesResult.serviceInstances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:compute:getNestServiceInstances
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:compute:getNestServiceInstances
     *       Arguments:
     *         nameRegex: tf-example
     * outputs:
     *   armsPrometheisId1: ${ids.serviceInstances[0].id}
     *   armsPrometheisId2: ${nameRegex.serviceInstances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNestServiceInstances.
     * @return A collection of values returned by getNestServiceInstances.
     */
    public suspend fun getNestServiceInstances(argument: GetNestServiceInstancesPlainArgs): GetNestServiceInstancesResult =
        toKotlin(getNestServiceInstancesPlain(argument.toJava()).await())

    /**
     * @see [getNestServiceInstances].
     * @param filters The conditions that are used to filter. See the following `Block filter`.
     * @param ids A list of Service Instance IDs.
     * @param nameRegex A regex string to filter results by Service Instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Service Instance. Valid Values: `Created`, `Deploying`, `DeployedFailed`, `Deployed`, `Upgrading`, `Deleting`, `Deleted`, `DeletedFailed`.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getNestServiceInstances.
     */
    public suspend fun getNestServiceInstances(
        filters: List<GetNestServiceInstancesFilter>? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetNestServiceInstancesResult {
        val argument = GetNestServiceInstancesPlainArgs(
            filters = filters,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            tags = tags,
        )
        return toKotlin(getNestServiceInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNestServiceInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;compute&#46;kotlin&#46;inputs&#46;GetNestServiceInstancesPlainArgs].
     * @return A collection of values returned by getNestServiceInstances.
     */
    public suspend fun getNestServiceInstances(argument: suspend GetNestServiceInstancesPlainArgsBuilder.() -> Unit): GetNestServiceInstancesResult {
        val builder = GetNestServiceInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getNestServiceInstancesPlain(builtArgument.toJava()).await())
    }
}
