@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.compute.kotlin.inputs

import com.pulumi.alicloud.compute.inputs.GetNestServiceInstancesFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the service.
 * @property values Set of values that are accepted for the given field.
 */
public data class GetNestServiceInstancesFilter(
    public val name: String? = null,
    public val values: List<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.compute.inputs.GetNestServiceInstancesFilter> {
    override fun toJava(): com.pulumi.alicloud.compute.inputs.GetNestServiceInstancesFilter =
        com.pulumi.alicloud.compute.inputs.GetNestServiceInstancesFilter.builder()
            .name(name?.let({ args0 -> args0 }))
            .values(values?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetNestServiceInstancesFilter].
 */
@PulumiTagMarker
public class GetNestServiceInstancesFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value The name of the service.
     */
    @JvmName("gbawdfjxywhuyxxt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Set of values that are accepted for the given field.
     */
    @JvmName("koghtwvyhefrkxym")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Set of values that are accepted for the given field.
     */
    @JvmName("blvscirmutvuegks")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetNestServiceInstancesFilter = GetNestServiceInstancesFilter(
        name = name,
        values = values,
    )
}
