@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.compute.kotlin.inputs

import com.pulumi.alicloud.compute.inputs.GetNestServiceInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNestServiceInstances.
 * @property filters The conditions that are used to filter. See the following `Block filter`.
 * @property ids A list of Service Instance IDs.
 * @property nameRegex A regex string to filter results by Service Instance name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Service Instance. Valid Values: `Created`, `Deploying`, `DeployedFailed`, `Deployed`, `Upgrading`, `Deleting`, `Deleted`, `DeletedFailed`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetNestServiceInstancesPlainArgs(
    public val filters: List<GetNestServiceInstancesFilter>? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.compute.inputs.GetNestServiceInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.compute.inputs.GetNestServiceInstancesPlainArgs =
        com.pulumi.alicloud.compute.inputs.GetNestServiceInstancesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetNestServiceInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetNestServiceInstancesPlainArgsBuilder internal constructor() {
    private var filters: List<GetNestServiceInstancesFilter>? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The conditions that are used to filter. See the following `Block filter`.
     */
    @JvmName("fwphtisokvukuhhd")
    public suspend fun filters(`value`: List<GetNestServiceInstancesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument The conditions that are used to filter. See the following `Block filter`.
     */
    @JvmName("uimnxkqemmyfilhy")
    public suspend fun filters(argument: List<suspend GetNestServiceInstancesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNestServiceInstancesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument The conditions that are used to filter. See the following `Block filter`.
     */
    @JvmName("bglsgpsrgyarowwb")
    public suspend fun filters(vararg argument: suspend GetNestServiceInstancesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetNestServiceInstancesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument The conditions that are used to filter. See the following `Block filter`.
     */
    @JvmName("xkyylqcndemybtpa")
    public suspend fun filters(argument: suspend GetNestServiceInstancesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetNestServiceInstancesFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values The conditions that are used to filter. See the following `Block filter`.
     */
    @JvmName("ldxcixwxboptqygx")
    public suspend fun filters(vararg values: GetNestServiceInstancesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value A list of Service Instance IDs.
     */
    @JvmName("igayrcxjnxlwqhmq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Service Instance IDs.
     */
    @JvmName("fxwaedxuycchnebm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Service Instance name.
     */
    @JvmName("hhnuctbcprxfyron")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jafsmejkjlbpnbow")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Service Instance. Valid Values: `Created`, `Deploying`, `DeployedFailed`, `Deployed`, `Upgrading`, `Deleting`, `Deleted`, `DeletedFailed`.
     */
    @JvmName("dknoubwvnbtbuwee")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("inbjqgovmuxafaky")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("kxjphchnsqubfmxt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetNestServiceInstancesPlainArgs = GetNestServiceInstancesPlainArgs(
        filters = filters,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        tags = tags,
    )
}
