@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.compute.kotlin.inputs

import com.pulumi.alicloud.compute.inputs.NestServiceInstanceCommodityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property payPeriod Length of purchase.
 * @property payPeriodUnit Duration unit. Valid values: `Year`, `Month`, `Day`.
 */
public data class NestServiceInstanceCommodityArgs(
    public val payPeriod: Output<Int>? = null,
    public val payPeriodUnit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.compute.inputs.NestServiceInstanceCommodityArgs> {
    override fun toJava(): com.pulumi.alicloud.compute.inputs.NestServiceInstanceCommodityArgs =
        com.pulumi.alicloud.compute.inputs.NestServiceInstanceCommodityArgs.builder()
            .payPeriod(payPeriod?.applyValue({ args0 -> args0 }))
            .payPeriodUnit(payPeriodUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NestServiceInstanceCommodityArgs].
 */
@PulumiTagMarker
public class NestServiceInstanceCommodityArgsBuilder internal constructor() {
    private var payPeriod: Output<Int>? = null

    private var payPeriodUnit: Output<String>? = null

    /**
     * @param value Length of purchase.
     */
    @JvmName("alufxnsofbirvjwd")
    public suspend fun payPeriod(`value`: Output<Int>) {
        this.payPeriod = value
    }

    /**
     * @param value Duration unit. Valid values: `Year`, `Month`, `Day`.
     */
    @JvmName("rlknenigbannvaly")
    public suspend fun payPeriodUnit(`value`: Output<String>) {
        this.payPeriodUnit = value
    }

    /**
     * @param value Length of purchase.
     */
    @JvmName("ynrxngsacucdquil")
    public suspend fun payPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payPeriod = mapped
    }

    /**
     * @param value Duration unit. Valid values: `Year`, `Month`, `Day`.
     */
    @JvmName("brbtxqvbyexsgfrt")
    public suspend fun payPeriodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payPeriodUnit = mapped
    }

    internal fun build(): NestServiceInstanceCommodityArgs = NestServiceInstanceCommodityArgs(
        payPeriod = payPeriod,
        payPeriodUnit = payPeriodUnit,
    )
}
