@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.compute.kotlin.inputs

import com.pulumi.alicloud.compute.inputs.NestServiceInstanceOperationMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property operatedServiceInstanceId The ID of the imported service instance.
 * @property operationEndTime The end time of O&M.
 * @property operationStartTime The start time of O&M.
 * @property resources The list of imported resources.
 */
public data class NestServiceInstanceOperationMetadataArgs(
    public val operatedServiceInstanceId: Output<String>? = null,
    public val operationEndTime: Output<String>? = null,
    public val operationStartTime: Output<String>? = null,
    public val resources: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.compute.inputs.NestServiceInstanceOperationMetadataArgs> {
    override fun toJava(): com.pulumi.alicloud.compute.inputs.NestServiceInstanceOperationMetadataArgs = com.pulumi.alicloud.compute.inputs.NestServiceInstanceOperationMetadataArgs.builder()
        .operatedServiceInstanceId(operatedServiceInstanceId?.applyValue({ args0 -> args0 }))
        .operationEndTime(operationEndTime?.applyValue({ args0 -> args0 }))
        .operationStartTime(operationStartTime?.applyValue({ args0 -> args0 }))
        .resources(resources?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NestServiceInstanceOperationMetadataArgs].
 */
@PulumiTagMarker
public class NestServiceInstanceOperationMetadataArgsBuilder internal constructor() {
    private var operatedServiceInstanceId: Output<String>? = null

    private var operationEndTime: Output<String>? = null

    private var operationStartTime: Output<String>? = null

    private var resources: Output<String>? = null

    /**
     * @param value The ID of the imported service instance.
     */
    @JvmName("rqibpafnfahvfihx")
    public suspend fun operatedServiceInstanceId(`value`: Output<String>) {
        this.operatedServiceInstanceId = value
    }

    /**
     * @param value The end time of O&M.
     */
    @JvmName("vgkulrcwswytuhsl")
    public suspend fun operationEndTime(`value`: Output<String>) {
        this.operationEndTime = value
    }

    /**
     * @param value The start time of O&M.
     */
    @JvmName("aqycqndapigrscvj")
    public suspend fun operationStartTime(`value`: Output<String>) {
        this.operationStartTime = value
    }

    /**
     * @param value The list of imported resources.
     */
    @JvmName("ginsvauliohyohfl")
    public suspend fun resources(`value`: Output<String>) {
        this.resources = value
    }

    /**
     * @param value The ID of the imported service instance.
     */
    @JvmName("veaxgchwyiaxfqww")
    public suspend fun operatedServiceInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatedServiceInstanceId = mapped
    }

    /**
     * @param value The end time of O&M.
     */
    @JvmName("vidygwgtpcprhkpj")
    public suspend fun operationEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationEndTime = mapped
    }

    /**
     * @param value The start time of O&M.
     */
    @JvmName("rsjxjsdejyxltcdl")
    public suspend fun operationStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationStartTime = mapped
    }

    /**
     * @param value The list of imported resources.
     */
    @JvmName("nftuubggujkbdhgt")
    public suspend fun resources(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    internal fun build(): NestServiceInstanceOperationMetadataArgs =
        NestServiceInstanceOperationMetadataArgs(
            operatedServiceInstanceId = operatedServiceInstanceId,
            operationEndTime = operationEndTime,
            operationStartTime = operationStartTime,
            resources = resources,
        )
}
