@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getNestServiceInstances.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Service Instance names.
 * @property outputFile
 * @property serviceInstances A list of Service Instances. Each element contains the following attributes:
 * @property status The status of the Service Instance.
 * @property tags The tag of the Service Instance.
 */
public data class GetNestServiceInstancesResult(
    public val filters: List<GetNestServiceInstancesFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val serviceInstances: List<GetNestServiceInstancesServiceInstance>,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.compute.outputs.GetNestServiceInstancesResult): GetNestServiceInstancesResult = GetNestServiceInstancesResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.compute.kotlin.outputs.GetNestServiceInstancesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            serviceInstances = javaType.serviceInstances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.compute.kotlin.outputs.GetNestServiceInstancesServiceInstance.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
