@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.compute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property enableInstanceOps Whether the service instance has the O&M function.
 * @property id The ID of the Service Instance.
 * @property operatedServiceInstanceId The ID of the imported service instance.
 * @property operationEndTime The end time of O&M.
 * @property operationStartTime The start time of O&M.
 * @property parameters The parameters entered by the deployment service instance.
 * @property resources The list of imported resources.
 * @property serviceInstanceId The ID of the Service Instance.
 * @property serviceInstanceName The name of the Service Instance.
 * @property services Service details.
 * @property source The source of the Service Instance.
 * @property status The status of the Service Instance. Valid Values: `Created`, `Deploying`, `DeployedFailed`, `Deployed`, `Upgrading`, `Deleting`, `Deleted`, `DeletedFailed`.
 * @property tags A mapping of tags to assign to the resource.
 * @property templateName The name of the template.
 */
public data class GetNestServiceInstancesServiceInstance(
    public val enableInstanceOps: Boolean,
    public val id: String,
    public val operatedServiceInstanceId: String,
    public val operationEndTime: String,
    public val operationStartTime: String,
    public val parameters: String,
    public val resources: String,
    public val serviceInstanceId: String,
    public val serviceInstanceName: String,
    public val services: List<GetNestServiceInstancesServiceInstanceService>,
    public val source: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val templateName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.compute.outputs.GetNestServiceInstancesServiceInstance): GetNestServiceInstancesServiceInstance = GetNestServiceInstancesServiceInstance(
            enableInstanceOps = javaType.enableInstanceOps(),
            id = javaType.id(),
            operatedServiceInstanceId = javaType.operatedServiceInstanceId(),
            operationEndTime = javaType.operationEndTime(),
            operationStartTime = javaType.operationStartTime(),
            parameters = javaType.parameters(),
            resources = javaType.resources(),
            serviceInstanceId = javaType.serviceInstanceId(),
            serviceInstanceName = javaType.serviceInstanceName(),
            services = javaType.services().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.compute.kotlin.outputs.GetNestServiceInstancesServiceInstanceService.Companion.toKotlin(args0)
                })
            }),
            source = javaType.source(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateName = javaType.templateName(),
        )
    }
}
