@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property deployType The type of the deployment.
 * @property publishTime The time of publish.
 * @property serviceId The id of the service.
 * @property serviceInfos Service information.
 * @property serviceType The type of the service.
 * @property status The status of the Service Instance. Valid Values: `Created`, `Deploying`, `DeployedFailed`, `Deployed`, `Upgrading`, `Deleting`, `Deleted`, `DeletedFailed`.
 * @property supplierName The name of the supplier.
 * @property supplierUrl The url of the supplier.
 * @property version The version of the service.
 * @property versionName The version name of the service.
 */
public data class GetNestServiceInstancesServiceInstanceService(
    public val deployType: String,
    public val publishTime: String,
    public val serviceId: String,
    public val serviceInfos: List<GetNestServiceInstancesServiceInstanceServiceServiceInfo>,
    public val serviceType: String,
    public val status: String,
    public val supplierName: String,
    public val supplierUrl: String,
    public val version: String,
    public val versionName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.compute.outputs.GetNestServiceInstancesServiceInstanceService): GetNestServiceInstancesServiceInstanceService =
            GetNestServiceInstancesServiceInstanceService(
                deployType = javaType.deployType(),
                publishTime = javaType.publishTime(),
                serviceId = javaType.serviceId(),
                serviceInfos = javaType.serviceInfos().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.compute.kotlin.outputs.GetNestServiceInstancesServiceInstanceServiceServiceInfo.Companion.toKotlin(args0)
                    })
                }),
                serviceType = javaType.serviceType(),
                status = javaType.status(),
                supplierName = javaType.supplierName(),
                supplierUrl = javaType.supplierUrl(),
                version = javaType.version(),
                versionName = javaType.versionName(),
            )
    }
}
