@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property operatedServiceInstanceId The ID of the imported service instance.
 * @property operationEndTime The end time of O&M.
 * @property operationStartTime The start time of O&M.
 * @property resources The list of imported resources.
 */
public data class NestServiceInstanceOperationMetadata(
    public val operatedServiceInstanceId: String? = null,
    public val operationEndTime: String? = null,
    public val operationStartTime: String? = null,
    public val resources: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.compute.outputs.NestServiceInstanceOperationMetadata): NestServiceInstanceOperationMetadata = NestServiceInstanceOperationMetadata(
            operatedServiceInstanceId = javaType.operatedServiceInstanceId().map({ args0 ->
                args0
            }).orElse(null),
            operationEndTime = javaType.operationEndTime().map({ args0 -> args0 }).orElse(null),
            operationStartTime = javaType.operationStartTime().map({ args0 -> args0 }).orElse(null),
            resources = javaType.resources().map({ args0 -> args0 }).orElse(null),
        )
    }
}
