@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.ChainArgs.builder
import com.pulumi.alicloud.cr.kotlin.inputs.ChainChainConfigArgs
import com.pulumi.alicloud.cr.kotlin.inputs.ChainChainConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a CR Chain resource.
 * For information about CR Chain and how to use it, see [What is Chain](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createchain).
 * > **NOTE:** Available since v1.161.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.cr.RegistryEnterpriseInstance("default", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const defaultRegistryEnterpriseNamespace = new alicloud.cs.RegistryEnterpriseNamespace("default", {
 *     instanceId: _default.id,
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * const defaultRegistryEnterpriseRepo = new alicloud.cs.RegistryEnterpriseRepo("default", {
 *     instanceId: _default.id,
 *     namespace: defaultRegistryEnterpriseNamespace.name,
 *     name: name,
 *     summary: "this is summary of my new repo",
 *     repoType: "PUBLIC",
 *     detail: "this is a public repo",
 * });
 * const defaultChain = new alicloud.cr.Chain("default", {
 *     chainConfigs: [{
 *         nodes: [
 *             {
 *                 nodeConfigs: [{
 *                     denyPolicies: [{}],
 *                 }],
 *                 enable: true,
 *                 nodeName: "DOCKER_IMAGE_BUILD",
 *             },
 *             {
 *                 nodeConfigs: [{
 *                     denyPolicies: [{}],
 *                 }],
 *                 enable: true,
 *                 nodeName: "DOCKER_IMAGE_PUSH",
 *             },
 *             {
 *                 enable: true,
 *                 nodeName: "VULNERABILITY_SCANNING",
 *                 nodeConfigs: [{
 *                     denyPolicies: [{
 *                         issueLevel: "MEDIUM",
 *                         issueCount: "1",
 *                         action: "BLOCK_DELETE_TAG",
 *                         logic: "AND",
 *                     }],
 *                 }],
 *             },
 *             {
 *                 nodeConfigs: [{
 *                     denyPolicies: [{}],
 *                 }],
 *                 enable: true,
 *                 nodeName: "ACTIVATE_REPLICATION",
 *             },
 *             {
 *                 nodeConfigs: [{
 *                     denyPolicies: [{}],
 *                 }],
 *                 enable: true,
 *                 nodeName: "TRIGGER",
 *             },
 *             {
 *                 nodeConfigs: [{
 *                     denyPolicies: [{}],
 *                 }],
 *                 enable: false,
 *                 nodeName: "SNAPSHOT",
 *             },
 *             {
 *                 nodeConfigs: [{
 *                     denyPolicies: [{}],
 *                 }],
 *                 enable: false,
 *                 nodeName: "TRIGGER_SNAPSHOT",
 *             },
 *         ],
 *         routers: [
 *             {
 *                 froms: [{
 *                     nodeName: "DOCKER_IMAGE_BUILD",
 *                 }],
 *                 tos: [{
 *                     nodeName: "DOCKER_IMAGE_PUSH",
 *                 }],
 *             },
 *             {
 *                 froms: [{
 *                     nodeName: "DOCKER_IMAGE_PUSH",
 *                 }],
 *                 tos: [{
 *                     nodeName: "VULNERABILITY_SCANNING",
 *                 }],
 *             },
 *             {
 *                 froms: [{
 *                     nodeName: "VULNERABILITY_SCANNING",
 *                 }],
 *                 tos: [{
 *                     nodeName: "ACTIVATE_REPLICATION",
 *                 }],
 *             },
 *             {
 *                 froms: [{
 *                     nodeName: "ACTIVATE_REPLICATION",
 *                 }],
 *                 tos: [{
 *                     nodeName: "TRIGGER",
 *                 }],
 *             },
 *             {
 *                 froms: [{
 *                     nodeName: "VULNERABILITY_SCANNING",
 *                 }],
 *                 tos: [{
 *                     nodeName: "SNAPSHOT",
 *                 }],
 *             },
 *             {
 *                 froms: [{
 *                     nodeName: "SNAPSHOT",
 *                 }],
 *                 tos: [{
 *                     nodeName: "TRIGGER_SNAPSHOT",
 *                 }],
 *             },
 *         ],
 *     }],
 *     chainName: name,
 *     description: name,
 *     instanceId: defaultRegistryEnterpriseNamespace.instanceId,
 *     repoName: defaultRegistryEnterpriseRepo.name,
 *     repoNamespaceName: defaultRegistryEnterpriseNamespace.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.cr.RegistryEnterpriseInstance("default",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * default_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("default",
 *     instance_id=default.id,
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * default_registry_enterprise_repo = alicloud.cs.RegistryEnterpriseRepo("default",
 *     instance_id=default.id,
 *     namespace=default_registry_enterprise_namespace.name,
 *     name=name,
 *     summary="this is summary of my new repo",
 *     repo_type="PUBLIC",
 *     detail="this is a public repo")
 * default_chain = alicloud.cr.Chain("default",
 *     chain_configs=[{
 *         "nodes": [
 *             {
 *                 "node_configs": [{
 *                     "deny_policies": [{}],
 *                 }],
 *                 "enable": True,
 *                 "node_name": "DOCKER_IMAGE_BUILD",
 *             },
 *             {
 *                 "node_configs": [{
 *                     "deny_policies": [{}],
 *                 }],
 *                 "enable": True,
 *                 "node_name": "DOCKER_IMAGE_PUSH",
 *             },
 *             {
 *                 "enable": True,
 *                 "node_name": "VULNERABILITY_SCANNING",
 *                 "node_configs": [{
 *                     "deny_policies": [{
 *                         "issue_level": "MEDIUM",
 *                         "issue_count": "1",
 *                         "action": "BLOCK_DELETE_TAG",
 *                         "logic": "AND",
 *                     }],
 *                 }],
 *             },
 *             {
 *                 "node_configs": [{
 *                     "deny_policies": [{}],
 *                 }],
 *                 "enable": True,
 *                 "node_name": "ACTIVATE_REPLICATION",
 *             },
 *             {
 *                 "node_configs": [{
 *                     "deny_policies": [{}],
 *                 }],
 *                 "enable": True,
 *                 "node_name": "TRIGGER",
 *             },
 *             {
 *                 "node_configs": [{
 *                     "deny_policies": [{}],
 *                 }],
 *                 "enable": False,
 *                 "node_name": "SNAPSHOT",
 *             },
 *             {
 *                 "node_configs": [{
 *                     "deny_policies": [{}],
 *                 }],
 *                 "enable": False,
 *                 "node_name": "TRIGGER_SNAPSHOT",
 *             },
 *         ],
 *         "routers": [
 *             {
 *                 "froms": [{
 *                     "node_name": "DOCKER_IMAGE_BUILD",
 *                 }],
 *                 "tos": [{
 *                     "node_name": "DOCKER_IMAGE_PUSH",
 *                 }],
 *             },
 *             {
 *                 "froms": [{
 *                     "node_name": "DOCKER_IMAGE_PUSH",
 *                 }],
 *                 "tos": [{
 *                     "node_name": "VULNERABILITY_SCANNING",
 *                 }],
 *             },
 *             {
 *                 "froms": [{
 *                     "node_name": "VULNERABILITY_SCANNING",
 *                 }],
 *                 "tos": [{
 *                     "node_name": "ACTIVATE_REPLICATION",
 *                 }],
 *             },
 *             {
 *                 "froms": [{
 *                     "node_name": "ACTIVATE_REPLICATION",
 *                 }],
 *                 "tos": [{
 *                     "node_name": "TRIGGER",
 *                 }],
 *             },
 *             {
 *                 "froms": [{
 *                     "node_name": "VULNERABILITY_SCANNING",
 *                 }],
 *                 "tos": [{
 *                     "node_name": "SNAPSHOT",
 *                 }],
 *             },
 *             {
 *                 "froms": [{
 *                     "node_name": "SNAPSHOT",
 *                 }],
 *                 "tos": [{
 *                     "node_name": "TRIGGER_SNAPSHOT",
 *                 }],
 *             },
 *         ],
 *     }],
 *     chain_name=name,
 *     description=name,
 *     instance_id=default_registry_enterprise_namespace.instance_id,
 *     repo_name=default_registry_enterprise_repo.name,
 *     repo_namespace_name=default_registry_enterprise_namespace.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.CR.RegistryEnterpriseInstance("default", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var defaultRegistryEnterpriseNamespace = new AliCloud.CS.RegistryEnterpriseNamespace("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 *     var defaultRegistryEnterpriseRepo = new AliCloud.CS.RegistryEnterpriseRepo("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         Namespace = defaultRegistryEnterpriseNamespace.Name,
 *         Name = name,
 *         Summary = "this is summary of my new repo",
 *         RepoType = "PUBLIC",
 *         Detail = "this is a public repo",
 *     });
 *     var defaultChain = new AliCloud.CR.Chain("default", new()
 *     {
 *         ChainConfigs = new[]
 *         {
 *             new AliCloud.CR.Inputs.ChainChainConfigArgs
 *             {
 *                 Nodes = new[]
 *                 {
 *                     new AliCloud.CR.Inputs.ChainChainConfigNodeArgs
 *                     {
 *                         NodeConfigs = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigNodeNodeConfigArgs
 *                             {
 *                                 DenyPolicies = new[]
 *                                 {
 *                                     null,
 *                                 },
 *                             },
 *                         },
 *                         Enable = true,
 *                         NodeName = "DOCKER_IMAGE_BUILD",
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigNodeArgs
 *                     {
 *                         NodeConfigs = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigNodeNodeConfigArgs
 *                             {
 *                                 DenyPolicies = new[]
 *                                 {
 *                                     null,
 *                                 },
 *                             },
 *                         },
 *                         Enable = true,
 *                         NodeName = "DOCKER_IMAGE_PUSH",
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigNodeArgs
 *                     {
 *                         Enable = true,
 *                         NodeName = "VULNERABILITY_SCANNING",
 *                         NodeConfigs = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigNodeNodeConfigArgs
 *                             {
 *                                 DenyPolicies = new[]
 *                                 {
 *                                     new AliCloud.CR.Inputs.ChainChainConfigNodeNodeConfigDenyPolicyArgs
 *                                     {
 *                                         IssueLevel = "MEDIUM",
 *                                         IssueCount = "1",
 *                                         Action = "BLOCK_DELETE_TAG",
 *                                         Logic = "AND",
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigNodeArgs
 *                     {
 *                         NodeConfigs = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigNodeNodeConfigArgs
 *                             {
 *                                 DenyPolicies = new[]
 *                                 {
 *                                     null,
 *                                 },
 *                             },
 *                         },
 *                         Enable = true,
 *                         NodeName = "ACTIVATE_REPLICATION",
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigNodeArgs
 *                     {
 *                         NodeConfigs = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigNodeNodeConfigArgs
 *                             {
 *                                 DenyPolicies = new[]
 *                                 {
 *                                     null,
 *                                 },
 *                             },
 *                         },
 *                         Enable = true,
 *                         NodeName = "TRIGGER",
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigNodeArgs
 *                     {
 *                         NodeConfigs = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigNodeNodeConfigArgs
 *                             {
 *                                 DenyPolicies = new[]
 *                                 {
 *                                     null,
 *                                 },
 *                             },
 *                         },
 *                         Enable = false,
 *                         NodeName = "SNAPSHOT",
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigNodeArgs
 *                     {
 *                         NodeConfigs = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigNodeNodeConfigArgs
 *                             {
 *                                 DenyPolicies = new[]
 *                                 {
 *                                     null,
 *                                 },
 *                             },
 *                         },
 *                         Enable = false,
 *                         NodeName = "TRIGGER_SNAPSHOT",
 *                     },
 *                 },
 *                 Routers = new[]
 *                 {
 *                     new AliCloud.CR.Inputs.ChainChainConfigRouterArgs
 *                     {
 *                         Froms = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterFromArgs
 *                             {
 *                                 NodeName = "DOCKER_IMAGE_BUILD",
 *                             },
 *                         },
 *                         Tos = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterToArgs
 *                             {
 *                                 NodeName = "DOCKER_IMAGE_PUSH",
 *                             },
 *                         },
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigRouterArgs
 *                     {
 *                         Froms = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterFromArgs
 *                             {
 *                                 NodeName = "DOCKER_IMAGE_PUSH",
 *                             },
 *                         },
 *                         Tos = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterToArgs
 *                             {
 *                                 NodeName = "VULNERABILITY_SCANNING",
 *                             },
 *                         },
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigRouterArgs
 *                     {
 *                         Froms = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterFromArgs
 *                             {
 *                                 NodeName = "VULNERABILITY_SCANNING",
 *                             },
 *                         },
 *                         Tos = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterToArgs
 *                             {
 *                                 NodeName = "ACTIVATE_REPLICATION",
 *                             },
 *                         },
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigRouterArgs
 *                     {
 *                         Froms = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterFromArgs
 *                             {
 *                                 NodeName = "ACTIVATE_REPLICATION",
 *                             },
 *                         },
 *                         Tos = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterToArgs
 *                             {
 *                                 NodeName = "TRIGGER",
 *                             },
 *                         },
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigRouterArgs
 *                     {
 *                         Froms = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterFromArgs
 *                             {
 *                                 NodeName = "VULNERABILITY_SCANNING",
 *                             },
 *                         },
 *                         Tos = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterToArgs
 *                             {
 *                                 NodeName = "SNAPSHOT",
 *                             },
 *                         },
 *                     },
 *                     new AliCloud.CR.Inputs.ChainChainConfigRouterArgs
 *                     {
 *                         Froms = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterFromArgs
 *                             {
 *                                 NodeName = "SNAPSHOT",
 *                             },
 *                         },
 *                         Tos = new[]
 *                         {
 *                             new AliCloud.CR.Inputs.ChainChainConfigRouterToArgs
 *                             {
 *                                 NodeName = "TRIGGER_SNAPSHOT",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ChainName = name,
 *         Description = name,
 *         InstanceId = defaultRegistryEnterpriseNamespace.InstanceId,
 *         RepoName = defaultRegistryEnterpriseRepo.Name,
 *         RepoNamespaceName = defaultRegistryEnterpriseNamespace.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cr.NewRegistryEnterpriseInstance(ctx, "default", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRegistryEnterpriseNamespace, err := cs.NewRegistryEnterpriseNamespace(ctx, "default", &cs.RegistryEnterpriseNamespaceArgs{
 * 			InstanceId:        _default.ID(),
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRegistryEnterpriseRepo, err := cs.NewRegistryEnterpriseRepo(ctx, "default", &cs.RegistryEnterpriseRepoArgs{
 * 			InstanceId: _default.ID(),
 * 			Namespace:  defaultRegistryEnterpriseNamespace.Name,
 * 			Name:       pulumi.String(name),
 * 			Summary:    pulumi.String("this is summary of my new repo"),
 * 			RepoType:   pulumi.String("PUBLIC"),
 * 			Detail:     pulumi.String("this is a public repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cr.NewChain(ctx, "default", &cr.ChainArgs{
 * 			ChainConfigs: cr.ChainChainConfigArray{
 * 				&cr.ChainChainConfigArgs{
 * 					Nodes: cr.ChainChainConfigNodeArray{
 * 						&cr.ChainChainConfigNodeArgs{
 * 							NodeConfigs: cr.ChainChainConfigNodeNodeConfigArray{
 * 								&cr.ChainChainConfigNodeNodeConfigArgs{
 * 									DenyPolicies: cr.ChainChainConfigNodeNodeConfigDenyPolicyArray{
 * 										nil,
 * 									},
 * 								},
 * 							},
 * 							Enable:   pulumi.Bool(true),
 * 							NodeName: pulumi.String("DOCKER_IMAGE_BUILD"),
 * 						},
 * 						&cr.ChainChainConfigNodeArgs{
 * 							NodeConfigs: cr.ChainChainConfigNodeNodeConfigArray{
 * 								&cr.ChainChainConfigNodeNodeConfigArgs{
 * 									DenyPolicies: cr.ChainChainConfigNodeNodeConfigDenyPolicyArray{
 * 										nil,
 * 									},
 * 								},
 * 							},
 * 							Enable:   pulumi.Bool(true),
 * 							NodeName: pulumi.String("DOCKER_IMAGE_PUSH"),
 * 						},
 * 						&cr.ChainChainConfigNodeArgs{
 * 							Enable:   pulumi.Bool(true),
 * 							NodeName: pulumi.String("VULNERABILITY_SCANNING"),
 * 							NodeConfigs: cr.ChainChainConfigNodeNodeConfigArray{
 * 								&cr.ChainChainConfigNodeNodeConfigArgs{
 * 									DenyPolicies: cr.ChainChainConfigNodeNodeConfigDenyPolicyArray{
 * 										&cr.ChainChainConfigNodeNodeConfigDenyPolicyArgs{
 * 											IssueLevel: pulumi.String("MEDIUM"),
 * 											IssueCount: pulumi.String("1"),
 * 											Action:     pulumi.String("BLOCK_DELETE_TAG"),
 * 											Logic:      pulumi.String("AND"),
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 						&cr.ChainChainConfigNodeArgs{
 * 							NodeConfigs: cr.ChainChainConfigNodeNodeConfigArray{
 * 								&cr.ChainChainConfigNodeNodeConfigArgs{
 * 									DenyPolicies: cr.ChainChainConfigNodeNodeConfigDenyPolicyArray{
 * 										nil,
 * 									},
 * 								},
 * 							},
 * 							Enable:   pulumi.Bool(true),
 * 							NodeName: pulumi.String("ACTIVATE_REPLICATION"),
 * 						},
 * 						&cr.ChainChainConfigNodeArgs{
 * 							NodeConfigs: cr.ChainChainConfigNodeNodeConfigArray{
 * 								&cr.ChainChainConfigNodeNodeConfigArgs{
 * 									DenyPolicies: cr.ChainChainConfigNodeNodeConfigDenyPolicyArray{
 * 										nil,
 * 									},
 * 								},
 * 							},
 * 							Enable:   pulumi.Bool(true),
 * 							NodeName: pulumi.String("TRIGGER"),
 * 						},
 * 						&cr.ChainChainConfigNodeArgs{
 * 							NodeConfigs: cr.ChainChainConfigNodeNodeConfigArray{
 * 								&cr.ChainChainConfigNodeNodeConfigArgs{
 * 									DenyPolicies: cr.ChainChainConfigNodeNodeConfigDenyPolicyArray{
 * 										nil,
 * 									},
 * 								},
 * 							},
 * 							Enable:   pulumi.Bool(false),
 * 							NodeName: pulumi.String("SNAPSHOT"),
 * 						},
 * 						&cr.ChainChainConfigNodeArgs{
 * 							NodeConfigs: cr.ChainChainConfigNodeNodeConfigArray{
 * 								&cr.ChainChainConfigNodeNodeConfigArgs{
 * 									DenyPolicies: cr.ChainChainConfigNodeNodeConfigDenyPolicyArray{
 * 										nil,
 * 									},
 * 								},
 * 							},
 * 							Enable:   pulumi.Bool(false),
 * 							NodeName: pulumi.String("TRIGGER_SNAPSHOT"),
 * 						},
 * 					},
 * 					Routers: cr.ChainChainConfigRouterArray{
 * 						&cr.ChainChainConfigRouterArgs{
 * 							Froms: cr.ChainChainConfigRouterFromArray{
 * 								&cr.ChainChainConfigRouterFromArgs{
 * 									NodeName: pulumi.String("DOCKER_IMAGE_BUILD"),
 * 								},
 * 							},
 * 							Tos: cr.ChainChainConfigRouterToArray{
 * 								&cr.ChainChainConfigRouterToArgs{
 * 									NodeName: pulumi.String("DOCKER_IMAGE_PUSH"),
 * 								},
 * 							},
 * 						},
 * 						&cr.ChainChainConfigRouterArgs{
 * 							Froms: cr.ChainChainConfigRouterFromArray{
 * 								&cr.ChainChainConfigRouterFromArgs{
 * 									NodeName: pulumi.String("DOCKER_IMAGE_PUSH"),
 * 								},
 * 							},
 * 							Tos: cr.ChainChainConfigRouterToArray{
 * 								&cr.ChainChainConfigRouterToArgs{
 * 									NodeName: pulumi.String("VULNERABILITY_SCANNING"),
 * 								},
 * 							},
 * 						},
 * 						&cr.ChainChainConfigRouterArgs{
 * 							Froms: cr.ChainChainConfigRouterFromArray{
 * 								&cr.ChainChainConfigRouterFromArgs{
 * 									NodeName: pulumi.String("VULNERABILITY_SCANNING"),
 * 								},
 * 							},
 * 							Tos: cr.ChainChainConfigRouterToArray{
 * 								&cr.ChainChainConfigRouterToArgs{
 * 									NodeName: pulumi.String("ACTIVATE_REPLICATION"),
 * 								},
 * 							},
 * 						},
 * 						&cr.ChainChainConfigRouterArgs{
 * 							Froms: cr.ChainChainConfigRouterFromArray{
 * 								&cr.ChainChainConfigRouterFromArgs{
 * 									NodeName: pulumi.String("ACTIVATE_REPLICATION"),
 * 								},
 * 							},
 * 							Tos: cr.ChainChainConfigRouterToArray{
 * 								&cr.ChainChainConfigRouterToArgs{
 * 									NodeName: pulumi.String("TRIGGER"),
 * 								},
 * 							},
 * 						},
 * 						&cr.ChainChainConfigRouterArgs{
 * 							Froms: cr.ChainChainConfigRouterFromArray{
 * 								&cr.ChainChainConfigRouterFromArgs{
 * 									NodeName: pulumi.String("VULNERABILITY_SCANNING"),
 * 								},
 * 							},
 * 							Tos: cr.ChainChainConfigRouterToArray{
 * 								&cr.ChainChainConfigRouterToArgs{
 * 									NodeName: pulumi.String("SNAPSHOT"),
 * 								},
 * 							},
 * 						},
 * 						&cr.ChainChainConfigRouterArgs{
 * 							Froms: cr.ChainChainConfigRouterFromArray{
 * 								&cr.ChainChainConfigRouterFromArgs{
 * 									NodeName: pulumi.String("SNAPSHOT"),
 * 								},
 * 							},
 * 							Tos: cr.ChainChainConfigRouterToArray{
 * 								&cr.ChainChainConfigRouterToArgs{
 * 									NodeName: pulumi.String("TRIGGER_SNAPSHOT"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ChainName:         pulumi.String(name),
 * 			Description:       pulumi.String(name),
 * 			InstanceId:        defaultRegistryEnterpriseNamespace.InstanceId,
 * 			RepoName:          defaultRegistryEnterpriseRepo.Name,
 * 			RepoNamespaceName: defaultRegistryEnterpriseNamespace.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespace;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseNamespaceArgs;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepo;
 * import com.pulumi.alicloud.cs.RegistryEnterpriseRepoArgs;
 * import com.pulumi.alicloud.cr.Chain;
 * import com.pulumi.alicloud.cr.ChainArgs;
 * import com.pulumi.alicloud.cr.inputs.ChainChainConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new RegistryEnterpriseInstance("default", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         var defaultRegistryEnterpriseNamespace = new RegistryEnterpriseNamespace("defaultRegistryEnterpriseNamespace", RegistryEnterpriseNamespaceArgs.builder()
 *             .instanceId(default_.id())
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *         var defaultRegistryEnterpriseRepo = new RegistryEnterpriseRepo("defaultRegistryEnterpriseRepo", RegistryEnterpriseRepoArgs.builder()
 *             .instanceId(default_.id())
 *             .namespace(defaultRegistryEnterpriseNamespace.name())
 *             .name(name)
 *             .summary("this is summary of my new repo")
 *             .repoType("PUBLIC")
 *             .detail("this is a public repo")
 *             .build());
 *         var defaultChain = new Chain("defaultChain", ChainArgs.builder()
 *             .chainConfigs(ChainChainConfigArgs.builder()
 *                 .nodes(
 *                     ChainChainConfigNodeArgs.builder()
 *                         .nodeConfigs(ChainChainConfigNodeNodeConfigArgs.builder()
 *                             .denyPolicies()
 *                             .build())
 *                         .enable(true)
 *                         .nodeName("DOCKER_IMAGE_BUILD")
 *                         .build(),
 *                     ChainChainConfigNodeArgs.builder()
 *                         .nodeConfigs(ChainChainConfigNodeNodeConfigArgs.builder()
 *                             .denyPolicies()
 *                             .build())
 *                         .enable(true)
 *                         .nodeName("DOCKER_IMAGE_PUSH")
 *                         .build(),
 *                     ChainChainConfigNodeArgs.builder()
 *                         .enable(true)
 *                         .nodeName("VULNERABILITY_SCANNING")
 *                         .nodeConfigs(ChainChainConfigNodeNodeConfigArgs.builder()
 *                             .denyPolicies(ChainChainConfigNodeNodeConfigDenyPolicyArgs.builder()
 *                                 .issueLevel("MEDIUM")
 *                                 .issueCount(1)
 *                                 .action("BLOCK_DELETE_TAG")
 *                                 .logic("AND")
 *                                 .build())
 *                             .build())
 *                         .build(),
 *                     ChainChainConfigNodeArgs.builder()
 *                         .nodeConfigs(ChainChainConfigNodeNodeConfigArgs.builder()
 *                             .denyPolicies()
 *                             .build())
 *                         .enable(true)
 *                         .nodeName("ACTIVATE_REPLICATION")
 *                         .build(),
 *                     ChainChainConfigNodeArgs.builder()
 *                         .nodeConfigs(ChainChainConfigNodeNodeConfigArgs.builder()
 *                             .denyPolicies()
 *                             .build())
 *                         .enable(true)
 *                         .nodeName("TRIGGER")
 *                         .build(),
 *                     ChainChainConfigNodeArgs.builder()
 *                         .nodeConfigs(ChainChainConfigNodeNodeConfigArgs.builder()
 *                             .denyPolicies()
 *                             .build())
 *                         .enable(false)
 *                         .nodeName("SNAPSHOT")
 *                         .build(),
 *                     ChainChainConfigNodeArgs.builder()
 *                         .nodeConfigs(ChainChainConfigNodeNodeConfigArgs.builder()
 *                             .denyPolicies()
 *                             .build())
 *                         .enable(false)
 *                         .nodeName("TRIGGER_SNAPSHOT")
 *                         .build())
 *                 .routers(
 *                     ChainChainConfigRouterArgs.builder()
 *                         .froms(ChainChainConfigRouterFromArgs.builder()
 *                             .nodeName("DOCKER_IMAGE_BUILD")
 *                             .build())
 *                         .tos(ChainChainConfigRouterToArgs.builder()
 *                             .nodeName("DOCKER_IMAGE_PUSH")
 *                             .build())
 *                         .build(),
 *                     ChainChainConfigRouterArgs.builder()
 *                         .froms(ChainChainConfigRouterFromArgs.builder()
 *                             .nodeName("DOCKER_IMAGE_PUSH")
 *                             .build())
 *                         .tos(ChainChainConfigRouterToArgs.builder()
 *                             .nodeName("VULNERABILITY_SCANNING")
 *                             .build())
 *                         .build(),
 *                     ChainChainConfigRouterArgs.builder()
 *                         .froms(ChainChainConfigRouterFromArgs.builder()
 *                             .nodeName("VULNERABILITY_SCANNING")
 *                             .build())
 *                         .tos(ChainChainConfigRouterToArgs.builder()
 *                             .nodeName("ACTIVATE_REPLICATION")
 *                             .build())
 *                         .build(),
 *                     ChainChainConfigRouterArgs.builder()
 *                         .froms(ChainChainConfigRouterFromArgs.builder()
 *                             .nodeName("ACTIVATE_REPLICATION")
 *                             .build())
 *                         .tos(ChainChainConfigRouterToArgs.builder()
 *                             .nodeName("TRIGGER")
 *                             .build())
 *                         .build(),
 *                     ChainChainConfigRouterArgs.builder()
 *                         .froms(ChainChainConfigRouterFromArgs.builder()
 *                             .nodeName("VULNERABILITY_SCANNING")
 *                             .build())
 *                         .tos(ChainChainConfigRouterToArgs.builder()
 *                             .nodeName("SNAPSHOT")
 *                             .build())
 *                         .build(),
 *                     ChainChainConfigRouterArgs.builder()
 *                         .froms(ChainChainConfigRouterFromArgs.builder()
 *                             .nodeName("SNAPSHOT")
 *                             .build())
 *                         .tos(ChainChainConfigRouterToArgs.builder()
 *                             .nodeName("TRIGGER_SNAPSHOT")
 *                             .build())
 *                         .build())
 *                 .build())
 *             .chainName(name)
 *             .description(name)
 *             .instanceId(defaultRegistryEnterpriseNamespace.instanceId())
 *             .repoName(defaultRegistryEnterpriseRepo.name())
 *             .repoNamespaceName(defaultRegistryEnterpriseNamespace.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   defaultRegistryEnterpriseNamespace:
 *     type: alicloud:cs:RegistryEnterpriseNamespace
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 *   defaultRegistryEnterpriseRepo:
 *     type: alicloud:cs:RegistryEnterpriseRepo
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       namespace: ${defaultRegistryEnterpriseNamespace.name}
 *       name: ${name}
 *       summary: this is summary of my new repo
 *       repoType: PUBLIC
 *       detail: this is a public repo
 *   defaultChain:
 *     type: alicloud:cr:Chain
 *     name: default
 *     properties:
 *       chainConfigs:
 *         - nodes:
 *             - nodeConfigs:
 *                 - denyPolicies:
 *                     - {}
 *               enable: true
 *               nodeName: DOCKER_IMAGE_BUILD
 *             - nodeConfigs:
 *                 - denyPolicies:
 *                     - {}
 *               enable: true
 *               nodeName: DOCKER_IMAGE_PUSH
 *             - enable: true
 *               nodeName: VULNERABILITY_SCANNING
 *               nodeConfigs:
 *                 - denyPolicies:
 *                     - issueLevel: MEDIUM
 *                       issueCount: 1
 *                       action: BLOCK_DELETE_TAG
 *                       logic: AND
 *             - nodeConfigs:
 *                 - denyPolicies:
 *                     - {}
 *               enable: true
 *               nodeName: ACTIVATE_REPLICATION
 *             - nodeConfigs:
 *                 - denyPolicies:
 *                     - {}
 *               enable: true
 *               nodeName: TRIGGER
 *             - nodeConfigs:
 *                 - denyPolicies:
 *                     - {}
 *               enable: false
 *               nodeName: SNAPSHOT
 *             - nodeConfigs:
 *                 - denyPolicies:
 *                     - {}
 *               enable: false
 *               nodeName: TRIGGER_SNAPSHOT
 *           routers:
 *             - froms:
 *                 - nodeName: DOCKER_IMAGE_BUILD
 *               tos:
 *                 - nodeName: DOCKER_IMAGE_PUSH
 *             - froms:
 *                 - nodeName: DOCKER_IMAGE_PUSH
 *               tos:
 *                 - nodeName: VULNERABILITY_SCANNING
 *             - froms:
 *                 - nodeName: VULNERABILITY_SCANNING
 *               tos:
 *                 - nodeName: ACTIVATE_REPLICATION
 *             - froms:
 *                 - nodeName: ACTIVATE_REPLICATION
 *               tos:
 *                 - nodeName: TRIGGER
 *             - froms:
 *                 - nodeName: VULNERABILITY_SCANNING
 *               tos:
 *                 - nodeName: SNAPSHOT
 *             - froms:
 *                 - nodeName: SNAPSHOT
 *               tos:
 *                 - nodeName: TRIGGER_SNAPSHOT
 *       chainName: ${name}
 *       description: ${name}
 *       instanceId: ${defaultRegistryEnterpriseNamespace.instanceId}
 *       repoName: ${defaultRegistryEnterpriseRepo.name}
 *       repoNamespaceName: ${defaultRegistryEnterpriseNamespace.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CR Chain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/chain:Chain example <instance_id>:<chain_id>
 * ```
 * @property chainConfigs The configuration of delivery chain. See `chain_config` below. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
 * @property chainName The name of delivery chain. The length of the name is 1-64 characters, lowercase English letters and numbers, and the separators "_", "-", "." can be used, noted that the separator cannot be at the first or last position.
 * @property description The description delivery chain.
 * @property instanceId The ID of CR Enterprise Edition instance.
 * @property repoName The name of CR Enterprise Edition repository. **NOTE:** This parameter must specify a correct value, otherwise the created resource will be incorrect.
 * @property repoNamespaceName The name of CR Enterprise Edition namespace. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
 */
public data class ChainArgs(
    public val chainConfigs: Output<List<ChainChainConfigArgs>>? = null,
    public val chainName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val repoName: Output<String>? = null,
    public val repoNamespaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.ChainArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.ChainArgs =
        com.pulumi.alicloud.cr.ChainArgs.builder()
            .chainConfigs(
                chainConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .chainName(chainName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .repoName(repoName?.applyValue({ args0 -> args0 }))
            .repoNamespaceName(repoNamespaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChainArgs].
 */
@PulumiTagMarker
public class ChainArgsBuilder internal constructor() {
    private var chainConfigs: Output<List<ChainChainConfigArgs>>? = null

    private var chainName: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var repoName: Output<String>? = null

    private var repoNamespaceName: Output<String>? = null

    /**
     * @param value The configuration of delivery chain. See `chain_config` below. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("acuinqqhipgkwyov")
    public suspend fun chainConfigs(`value`: Output<List<ChainChainConfigArgs>>) {
        this.chainConfigs = value
    }

    @JvmName("nngpdfajlbqkdgid")
    public suspend fun chainConfigs(vararg values: Output<ChainChainConfigArgs>) {
        this.chainConfigs = Output.all(values.asList())
    }

    /**
     * @param values The configuration of delivery chain. See `chain_config` below. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("dltvpvtwndgulfqg")
    public suspend fun chainConfigs(values: List<Output<ChainChainConfigArgs>>) {
        this.chainConfigs = Output.all(values)
    }

    /**
     * @param value The name of delivery chain. The length of the name is 1-64 characters, lowercase English letters and numbers, and the separators "_", "-", "." can be used, noted that the separator cannot be at the first or last position.
     */
    @JvmName("jykkbmeuqwpovtre")
    public suspend fun chainName(`value`: Output<String>) {
        this.chainName = value
    }

    /**
     * @param value The description delivery chain.
     */
    @JvmName("ittaanevxnlfpadg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of CR Enterprise Edition instance.
     */
    @JvmName("eotaastoqbghknbt")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of CR Enterprise Edition repository. **NOTE:** This parameter must specify a correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("qkpfllssxrmklekt")
    public suspend fun repoName(`value`: Output<String>) {
        this.repoName = value
    }

    /**
     * @param value The name of CR Enterprise Edition namespace. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("cajojxsmiehiesih")
    public suspend fun repoNamespaceName(`value`: Output<String>) {
        this.repoNamespaceName = value
    }

    /**
     * @param value The configuration of delivery chain. See `chain_config` below. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("vrtexemxvwnqvfry")
    public suspend fun chainConfigs(`value`: List<ChainChainConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chainConfigs = mapped
    }

    /**
     * @param argument The configuration of delivery chain. See `chain_config` below. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("qjejfrhylaskgnoq")
    public suspend fun chainConfigs(argument: List<suspend ChainChainConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.chainConfigs = mapped
    }

    /**
     * @param argument The configuration of delivery chain. See `chain_config` below. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("kvqodcbxybojdxta")
    public suspend fun chainConfigs(vararg argument: suspend ChainChainConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.chainConfigs = mapped
    }

    /**
     * @param argument The configuration of delivery chain. See `chain_config` below. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("nooqrdbrhbgevvow")
    public suspend fun chainConfigs(argument: suspend ChainChainConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ChainChainConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.chainConfigs = mapped
    }

    /**
     * @param values The configuration of delivery chain. See `chain_config` below. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("dhxomqtyxbyhnvhe")
    public suspend fun chainConfigs(vararg values: ChainChainConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.chainConfigs = mapped
    }

    /**
     * @param value The name of delivery chain. The length of the name is 1-64 characters, lowercase English letters and numbers, and the separators "_", "-", "." can be used, noted that the separator cannot be at the first or last position.
     */
    @JvmName("hxadyysfaycisrnf")
    public suspend fun chainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chainName = mapped
    }

    /**
     * @param value The description delivery chain.
     */
    @JvmName("qxwrjnlofxumswju")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of CR Enterprise Edition instance.
     */
    @JvmName("yqedodhncahjcijk")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of CR Enterprise Edition repository. **NOTE:** This parameter must specify a correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("skiikewvweefimsc")
    public suspend fun repoName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoName = mapped
    }

    /**
     * @param value The name of CR Enterprise Edition namespace. **NOTE:** This parameter must specify the correct value, otherwise the created resource will be incorrect.
     */
    @JvmName("fmyewkhrqbegnopw")
    public suspend fun repoNamespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoNamespaceName = mapped
    }

    internal fun build(): ChainArgs = ChainArgs(
        chainConfigs = chainConfigs,
        chainName = chainName,
        description = description,
        instanceId = instanceId,
        repoName = repoName,
        repoNamespaceName = repoNamespaceName,
    )
}
