@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ChartNamespace].
 */
@PulumiTagMarker
public class ChartNamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChartNamespaceArgs = ChartNamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChartNamespaceArgsBuilder.() -> Unit) {
        val builder = ChartNamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ChartNamespace {
        val builtJavaResource = com.pulumi.alicloud.cr.ChartNamespace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ChartNamespace(builtJavaResource)
    }
}

/**
 * Provides a CR Chart Namespace resource.
 * For information about CR Chart Namespace and how to use it, see [What is Chart Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createchartnamespace).
 * > **NOTE:** Available since v1.149.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "example-name";
 * const example = new alicloud.cr.RegistryEnterpriseInstance("example", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const exampleChartNamespace = new alicloud.cr.ChartNamespace("example", {
 *     instanceId: example.id,
 *     namespaceName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "example-name"
 * example = alicloud.cr.RegistryEnterpriseInstance("example",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * example_chart_namespace = alicloud.cr.ChartNamespace("example",
 *     instance_id=example.id,
 *     namespace_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "example-name";
 *     var example = new AliCloud.CR.RegistryEnterpriseInstance("example", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var exampleChartNamespace = new AliCloud.CR.ChartNamespace("example", new()
 *     {
 *         InstanceId = example.Id,
 *         NamespaceName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "example-name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := cr.NewRegistryEnterpriseInstance(ctx, "example", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cr.NewChartNamespace(ctx, "example", &cr.ChartNamespaceArgs{
 * 			InstanceId:    example.ID(),
 * 			NamespaceName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cr.ChartNamespace;
 * import com.pulumi.alicloud.cr.ChartNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("example-name");
 *         var example = new RegistryEnterpriseInstance("example", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         var exampleChartNamespace = new ChartNamespace("exampleChartNamespace", ChartNamespaceArgs.builder()
 *             .instanceId(example.id())
 *             .namespaceName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: example-name
 * resources:
 *   example:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   exampleChartNamespace:
 *     type: alicloud:cr:ChartNamespace
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       namespaceName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CR Chart Namespace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/chartNamespace:ChartNamespace example <instance_id>:<namespace_name>
 * ```
 */
public class ChartNamespace internal constructor(
    override val javaResource: com.pulumi.alicloud.cr.ChartNamespace,
) : KotlinCustomResource(javaResource, ChartNamespaceMapper) {
    /**
     * Specifies whether to automatically create repositories in the namespace. Valid values:
     */
    public val autoCreateRepo: Output<Boolean>
        get() = javaResource.autoCreateRepo().applyValue({ args0 -> args0 })

    /**
     * DefaultRepoType. Valid values: `PRIVATE`, `PUBLIC`.
     */
    public val defaultRepoType: Output<String>
        get() = javaResource.defaultRepoType().applyValue({ args0 -> args0 })

    /**
     * The ID of the Container Registry instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The name of the namespace that you want to create.
     */
    public val namespaceName: Output<String>
        get() = javaResource.namespaceName().applyValue({ args0 -> args0 })
}

public object ChartNamespaceMapper : ResourceMapper<ChartNamespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cr.ChartNamespace::class == javaResource::class

    override fun map(javaResource: Resource): ChartNamespace = ChartNamespace(
        javaResource as
            com.pulumi.alicloud.cr.ChartNamespace,
    )
}

/**
 * @see [ChartNamespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ChartNamespace].
 */
public suspend fun chartNamespace(
    name: String,
    block: suspend ChartNamespaceResourceBuilder.() -> Unit,
): ChartNamespace {
    val builder = ChartNamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ChartNamespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun chartNamespace(name: String): ChartNamespace {
    val builder = ChartNamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
