@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.ChartNamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CR Chart Namespace resource.
 * For information about CR Chart Namespace and how to use it, see [What is Chart Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createchartnamespace).
 * > **NOTE:** Available since v1.149.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "example-name";
 * const example = new alicloud.cr.RegistryEnterpriseInstance("example", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const exampleChartNamespace = new alicloud.cr.ChartNamespace("example", {
 *     instanceId: example.id,
 *     namespaceName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "example-name"
 * example = alicloud.cr.RegistryEnterpriseInstance("example",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * example_chart_namespace = alicloud.cr.ChartNamespace("example",
 *     instance_id=example.id,
 *     namespace_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "example-name";
 *     var example = new AliCloud.CR.RegistryEnterpriseInstance("example", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var exampleChartNamespace = new AliCloud.CR.ChartNamespace("example", new()
 *     {
 *         InstanceId = example.Id,
 *         NamespaceName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "example-name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := cr.NewRegistryEnterpriseInstance(ctx, "example", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cr.NewChartNamespace(ctx, "example", &cr.ChartNamespaceArgs{
 * 			InstanceId:    example.ID(),
 * 			NamespaceName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cr.ChartNamespace;
 * import com.pulumi.alicloud.cr.ChartNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("example-name");
 *         var example = new RegistryEnterpriseInstance("example", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         var exampleChartNamespace = new ChartNamespace("exampleChartNamespace", ChartNamespaceArgs.builder()
 *             .instanceId(example.id())
 *             .namespaceName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: example-name
 * resources:
 *   example:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   exampleChartNamespace:
 *     type: alicloud:cr:ChartNamespace
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       namespaceName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CR Chart Namespace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/chartNamespace:ChartNamespace example <instance_id>:<namespace_name>
 * ```
 * @property autoCreateRepo Specifies whether to automatically create repositories in the namespace. Valid values:
 * @property defaultRepoType DefaultRepoType. Valid values: `PRIVATE`, `PUBLIC`.
 * @property instanceId The ID of the Container Registry instance.
 * @property namespaceName The name of the namespace that you want to create.
 */
public data class ChartNamespaceArgs(
    public val autoCreateRepo: Output<Boolean>? = null,
    public val defaultRepoType: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.ChartNamespaceArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.ChartNamespaceArgs =
        com.pulumi.alicloud.cr.ChartNamespaceArgs.builder()
            .autoCreateRepo(autoCreateRepo?.applyValue({ args0 -> args0 }))
            .defaultRepoType(defaultRepoType?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChartNamespaceArgs].
 */
@PulumiTagMarker
public class ChartNamespaceArgsBuilder internal constructor() {
    private var autoCreateRepo: Output<Boolean>? = null

    private var defaultRepoType: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var namespaceName: Output<String>? = null

    /**
     * @param value Specifies whether to automatically create repositories in the namespace. Valid values:
     */
    @JvmName("erpeqmwrsymlnmjl")
    public suspend fun autoCreateRepo(`value`: Output<Boolean>) {
        this.autoCreateRepo = value
    }

    /**
     * @param value DefaultRepoType. Valid values: `PRIVATE`, `PUBLIC`.
     */
    @JvmName("ekgkbenyidmtyrdt")
    public suspend fun defaultRepoType(`value`: Output<String>) {
        this.defaultRepoType = value
    }

    /**
     * @param value The ID of the Container Registry instance.
     */
    @JvmName("dctqbsgjnaurkoxy")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of the namespace that you want to create.
     */
    @JvmName("wyyipxwrvkpljirw")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Specifies whether to automatically create repositories in the namespace. Valid values:
     */
    @JvmName("osedvjgmiefpisxi")
    public suspend fun autoCreateRepo(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCreateRepo = mapped
    }

    /**
     * @param value DefaultRepoType. Valid values: `PRIVATE`, `PUBLIC`.
     */
    @JvmName("avvnwlwnvnfxpcsa")
    public suspend fun defaultRepoType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRepoType = mapped
    }

    /**
     * @param value The ID of the Container Registry instance.
     */
    @JvmName("nlhfgmeeladtngbd")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the namespace that you want to create.
     */
    @JvmName("uccytdbwvfuxvnwb")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    internal fun build(): ChartNamespaceArgs = ChartNamespaceArgs(
        autoCreateRepo = autoCreateRepo,
        defaultRepoType = defaultRepoType,
        instanceId = instanceId,
        namespaceName = namespaceName,
    )
}
