@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ChartRepository].
 */
@PulumiTagMarker
public class ChartRepositoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChartRepositoryArgs = ChartRepositoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChartRepositoryArgsBuilder.() -> Unit) {
        val builder = ChartRepositoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ChartRepository {
        val builtJavaResource = com.pulumi.alicloud.cr.ChartRepository(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ChartRepository(builtJavaResource)
    }
}

/**
 * Provides a CR Chart Repository resource.
 * For information about CR Chart Repository and how to use it, see [What is Chart Repository](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createchartrepository).
 * > **NOTE:** Available since v1.149.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.cr.RegistryEnterpriseInstance("example", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const exampleChartNamespace = new alicloud.cr.ChartNamespace("example", {
 *     instanceId: example.id,
 *     namespaceName: name,
 * });
 * const exampleChartRepository = new alicloud.cr.ChartRepository("example", {
 *     repoNamespaceName: exampleChartNamespace.namespaceName,
 *     instanceId: exampleChartNamespace.instanceId,
 *     repoName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.cr.RegistryEnterpriseInstance("example",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * example_chart_namespace = alicloud.cr.ChartNamespace("example",
 *     instance_id=example.id,
 *     namespace_name=name)
 * example_chart_repository = alicloud.cr.ChartRepository("example",
 *     repo_namespace_name=example_chart_namespace.namespace_name,
 *     instance_id=example_chart_namespace.instance_id,
 *     repo_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.CR.RegistryEnterpriseInstance("example", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var exampleChartNamespace = new AliCloud.CR.ChartNamespace("example", new()
 *     {
 *         InstanceId = example.Id,
 *         NamespaceName = name,
 *     });
 *     var exampleChartRepository = new AliCloud.CR.ChartRepository("example", new()
 *     {
 *         RepoNamespaceName = exampleChartNamespace.NamespaceName,
 *         InstanceId = exampleChartNamespace.InstanceId,
 *         RepoName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := cr.NewRegistryEnterpriseInstance(ctx, "example", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleChartNamespace, err := cr.NewChartNamespace(ctx, "example", &cr.ChartNamespaceArgs{
 * 			InstanceId:    example.ID(),
 * 			NamespaceName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cr.NewChartRepository(ctx, "example", &cr.ChartRepositoryArgs{
 * 			RepoNamespaceName: exampleChartNamespace.NamespaceName,
 * 			InstanceId:        exampleChartNamespace.InstanceId,
 * 			RepoName:          pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cr.ChartNamespace;
 * import com.pulumi.alicloud.cr.ChartNamespaceArgs;
 * import com.pulumi.alicloud.cr.ChartRepository;
 * import com.pulumi.alicloud.cr.ChartRepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new RegistryEnterpriseInstance("example", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         var exampleChartNamespace = new ChartNamespace("exampleChartNamespace", ChartNamespaceArgs.builder()
 *             .instanceId(example.id())
 *             .namespaceName(name)
 *             .build());
 *         var exampleChartRepository = new ChartRepository("exampleChartRepository", ChartRepositoryArgs.builder()
 *             .repoNamespaceName(exampleChartNamespace.namespaceName())
 *             .instanceId(exampleChartNamespace.instanceId())
 *             .repoName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   exampleChartNamespace:
 *     type: alicloud:cr:ChartNamespace
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       namespaceName: ${name}
 *   exampleChartRepository:
 *     type: alicloud:cr:ChartRepository
 *     name: example
 *     properties:
 *       repoNamespaceName: ${exampleChartNamespace.namespaceName}
 *       instanceId: ${exampleChartNamespace.instanceId}
 *       repoName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CR Chart Repository can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/chartRepository:ChartRepository example <instance_id>:<repo_namespace_name>:<repo_name>
 * ```
 */
public class ChartRepository internal constructor(
    override val javaResource: com.pulumi.alicloud.cr.ChartRepository,
) : KotlinCustomResource(javaResource, ChartRepositoryMapper) {
    /**
     * The ID of the Container Registry instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The name of the repository that you want to create.
     */
    public val repoName: Output<String>
        get() = javaResource.repoName().applyValue({ args0 -> args0 })

    /**
     * The namespace to which the repository belongs.
     */
    public val repoNamespaceName: Output<String>
        get() = javaResource.repoNamespaceName().applyValue({ args0 -> args0 })

    /**
     * The default repository type. Valid values: `PUBLIC`,`PRIVATE`.
     */
    public val repoType: Output<String>
        get() = javaResource.repoType().applyValue({ args0 -> args0 })

    /**
     * The summary about the repository.
     */
    public val summary: Output<String>?
        get() = javaResource.summary().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ChartRepositoryMapper : ResourceMapper<ChartRepository> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cr.ChartRepository::class == javaResource::class

    override fun map(javaResource: Resource): ChartRepository = ChartRepository(
        javaResource as
            com.pulumi.alicloud.cr.ChartRepository,
    )
}

/**
 * @see [ChartRepository].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ChartRepository].
 */
public suspend fun chartRepository(
    name: String,
    block: suspend ChartRepositoryResourceBuilder.() -> Unit,
): ChartRepository {
    val builder = ChartRepositoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ChartRepository].
 * @param name The _unique_ name of the resulting resource.
 */
public fun chartRepository(name: String): ChartRepository {
    val builder = ChartRepositoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
