@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.ChartRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CR Chart Repository resource.
 * For information about CR Chart Repository and how to use it, see [What is Chart Repository](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createchartrepository).
 * > **NOTE:** Available since v1.149.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.cr.RegistryEnterpriseInstance("example", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const exampleChartNamespace = new alicloud.cr.ChartNamespace("example", {
 *     instanceId: example.id,
 *     namespaceName: name,
 * });
 * const exampleChartRepository = new alicloud.cr.ChartRepository("example", {
 *     repoNamespaceName: exampleChartNamespace.namespaceName,
 *     instanceId: exampleChartNamespace.instanceId,
 *     repoName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.cr.RegistryEnterpriseInstance("example",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * example_chart_namespace = alicloud.cr.ChartNamespace("example",
 *     instance_id=example.id,
 *     namespace_name=name)
 * example_chart_repository = alicloud.cr.ChartRepository("example",
 *     repo_namespace_name=example_chart_namespace.namespace_name,
 *     instance_id=example_chart_namespace.instance_id,
 *     repo_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.CR.RegistryEnterpriseInstance("example", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var exampleChartNamespace = new AliCloud.CR.ChartNamespace("example", new()
 *     {
 *         InstanceId = example.Id,
 *         NamespaceName = name,
 *     });
 *     var exampleChartRepository = new AliCloud.CR.ChartRepository("example", new()
 *     {
 *         RepoNamespaceName = exampleChartNamespace.NamespaceName,
 *         InstanceId = exampleChartNamespace.InstanceId,
 *         RepoName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := cr.NewRegistryEnterpriseInstance(ctx, "example", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleChartNamespace, err := cr.NewChartNamespace(ctx, "example", &cr.ChartNamespaceArgs{
 * 			InstanceId:    example.ID(),
 * 			NamespaceName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cr.NewChartRepository(ctx, "example", &cr.ChartRepositoryArgs{
 * 			RepoNamespaceName: exampleChartNamespace.NamespaceName,
 * 			InstanceId:        exampleChartNamespace.InstanceId,
 * 			RepoName:          pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cr.ChartNamespace;
 * import com.pulumi.alicloud.cr.ChartNamespaceArgs;
 * import com.pulumi.alicloud.cr.ChartRepository;
 * import com.pulumi.alicloud.cr.ChartRepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new RegistryEnterpriseInstance("example", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         var exampleChartNamespace = new ChartNamespace("exampleChartNamespace", ChartNamespaceArgs.builder()
 *             .instanceId(example.id())
 *             .namespaceName(name)
 *             .build());
 *         var exampleChartRepository = new ChartRepository("exampleChartRepository", ChartRepositoryArgs.builder()
 *             .repoNamespaceName(exampleChartNamespace.namespaceName())
 *             .instanceId(exampleChartNamespace.instanceId())
 *             .repoName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   exampleChartNamespace:
 *     type: alicloud:cr:ChartNamespace
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       namespaceName: ${name}
 *   exampleChartRepository:
 *     type: alicloud:cr:ChartRepository
 *     name: example
 *     properties:
 *       repoNamespaceName: ${exampleChartNamespace.namespaceName}
 *       instanceId: ${exampleChartNamespace.instanceId}
 *       repoName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CR Chart Repository can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/chartRepository:ChartRepository example <instance_id>:<repo_namespace_name>:<repo_name>
 * ```
 * @property instanceId The ID of the Container Registry instance.
 * @property repoName The name of the repository that you want to create.
 * @property repoNamespaceName The namespace to which the repository belongs.
 * @property repoType The default repository type. Valid values: `PUBLIC`,`PRIVATE`.
 * @property summary The summary about the repository.
 */
public data class ChartRepositoryArgs(
    public val instanceId: Output<String>? = null,
    public val repoName: Output<String>? = null,
    public val repoNamespaceName: Output<String>? = null,
    public val repoType: Output<String>? = null,
    public val summary: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.ChartRepositoryArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.ChartRepositoryArgs =
        com.pulumi.alicloud.cr.ChartRepositoryArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .repoName(repoName?.applyValue({ args0 -> args0 }))
            .repoNamespaceName(repoNamespaceName?.applyValue({ args0 -> args0 }))
            .repoType(repoType?.applyValue({ args0 -> args0 }))
            .summary(summary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChartRepositoryArgs].
 */
@PulumiTagMarker
public class ChartRepositoryArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var repoName: Output<String>? = null

    private var repoNamespaceName: Output<String>? = null

    private var repoType: Output<String>? = null

    private var summary: Output<String>? = null

    /**
     * @param value The ID of the Container Registry instance.
     */
    @JvmName("nffxpgmqjcrlbkmb")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of the repository that you want to create.
     */
    @JvmName("igmofmoydnvqfdby")
    public suspend fun repoName(`value`: Output<String>) {
        this.repoName = value
    }

    /**
     * @param value The namespace to which the repository belongs.
     */
    @JvmName("eurooadcxmnlkwmq")
    public suspend fun repoNamespaceName(`value`: Output<String>) {
        this.repoNamespaceName = value
    }

    /**
     * @param value The default repository type. Valid values: `PUBLIC`,`PRIVATE`.
     */
    @JvmName("vjsuqqkdtnomdkfc")
    public suspend fun repoType(`value`: Output<String>) {
        this.repoType = value
    }

    /**
     * @param value The summary about the repository.
     */
    @JvmName("jqrcrmirgroikcjn")
    public suspend fun summary(`value`: Output<String>) {
        this.summary = value
    }

    /**
     * @param value The ID of the Container Registry instance.
     */
    @JvmName("gayryabvvvdoshxr")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the repository that you want to create.
     */
    @JvmName("odltsakdxdjpocsw")
    public suspend fun repoName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoName = mapped
    }

    /**
     * @param value The namespace to which the repository belongs.
     */
    @JvmName("uputbqaxajilfesj")
    public suspend fun repoNamespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoNamespaceName = mapped
    }

    /**
     * @param value The default repository type. Valid values: `PUBLIC`,`PRIVATE`.
     */
    @JvmName("gypeepluqyoswpsv")
    public suspend fun repoType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoType = mapped
    }

    /**
     * @param value The summary about the repository.
     */
    @JvmName("thdryhsftnunaxfg")
    public suspend fun summary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.summary = mapped
    }

    internal fun build(): ChartRepositoryArgs = ChartRepositoryArgs(
        instanceId = instanceId,
        repoName = repoName,
        repoNamespaceName = repoNamespaceName,
        repoType = repoType,
        summary = summary,
    )
}
