@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.CrFunctions.getChainsPlain
import com.pulumi.alicloud.cr.CrFunctions.getChartNamespacesPlain
import com.pulumi.alicloud.cr.CrFunctions.getChartRepositoriesPlain
import com.pulumi.alicloud.cr.CrFunctions.getEndpointAclPoliciesPlain
import com.pulumi.alicloud.cr.CrFunctions.getEndpointAclServicePlain
import com.pulumi.alicloud.cr.CrFunctions.getNamespacesPlain
import com.pulumi.alicloud.cr.CrFunctions.getReposPlain
import com.pulumi.alicloud.cr.CrFunctions.getServicePlain
import com.pulumi.alicloud.cr.CrFunctions.getVpcEndpointLinkedVpcsPlain
import com.pulumi.alicloud.cr.kotlin.inputs.GetChainsPlainArgs
import com.pulumi.alicloud.cr.kotlin.inputs.GetChainsPlainArgsBuilder
import com.pulumi.alicloud.cr.kotlin.inputs.GetChartNamespacesPlainArgs
import com.pulumi.alicloud.cr.kotlin.inputs.GetChartNamespacesPlainArgsBuilder
import com.pulumi.alicloud.cr.kotlin.inputs.GetChartRepositoriesPlainArgs
import com.pulumi.alicloud.cr.kotlin.inputs.GetChartRepositoriesPlainArgsBuilder
import com.pulumi.alicloud.cr.kotlin.inputs.GetEndpointAclPoliciesPlainArgs
import com.pulumi.alicloud.cr.kotlin.inputs.GetEndpointAclPoliciesPlainArgsBuilder
import com.pulumi.alicloud.cr.kotlin.inputs.GetEndpointAclServicePlainArgs
import com.pulumi.alicloud.cr.kotlin.inputs.GetEndpointAclServicePlainArgsBuilder
import com.pulumi.alicloud.cr.kotlin.inputs.GetNamespacesPlainArgs
import com.pulumi.alicloud.cr.kotlin.inputs.GetNamespacesPlainArgsBuilder
import com.pulumi.alicloud.cr.kotlin.inputs.GetReposPlainArgs
import com.pulumi.alicloud.cr.kotlin.inputs.GetReposPlainArgsBuilder
import com.pulumi.alicloud.cr.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.cr.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.cr.kotlin.inputs.GetVpcEndpointLinkedVpcsPlainArgs
import com.pulumi.alicloud.cr.kotlin.inputs.GetVpcEndpointLinkedVpcsPlainArgsBuilder
import com.pulumi.alicloud.cr.kotlin.outputs.GetChainsResult
import com.pulumi.alicloud.cr.kotlin.outputs.GetChartNamespacesResult
import com.pulumi.alicloud.cr.kotlin.outputs.GetChartRepositoriesResult
import com.pulumi.alicloud.cr.kotlin.outputs.GetEndpointAclPoliciesResult
import com.pulumi.alicloud.cr.kotlin.outputs.GetEndpointAclServiceResult
import com.pulumi.alicloud.cr.kotlin.outputs.GetNamespacesResult
import com.pulumi.alicloud.cr.kotlin.outputs.GetReposResult
import com.pulumi.alicloud.cr.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.cr.kotlin.outputs.GetVpcEndpointLinkedVpcsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cr.kotlin.outputs.GetChainsResult.Companion.toKotlin as getChainsResultToKotlin
import com.pulumi.alicloud.cr.kotlin.outputs.GetChartNamespacesResult.Companion.toKotlin as getChartNamespacesResultToKotlin
import com.pulumi.alicloud.cr.kotlin.outputs.GetChartRepositoriesResult.Companion.toKotlin as getChartRepositoriesResultToKotlin
import com.pulumi.alicloud.cr.kotlin.outputs.GetEndpointAclPoliciesResult.Companion.toKotlin as getEndpointAclPoliciesResultToKotlin
import com.pulumi.alicloud.cr.kotlin.outputs.GetEndpointAclServiceResult.Companion.toKotlin as getEndpointAclServiceResultToKotlin
import com.pulumi.alicloud.cr.kotlin.outputs.GetNamespacesResult.Companion.toKotlin as getNamespacesResultToKotlin
import com.pulumi.alicloud.cr.kotlin.outputs.GetReposResult.Companion.toKotlin as getReposResultToKotlin
import com.pulumi.alicloud.cr.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.cr.kotlin.outputs.GetVpcEndpointLinkedVpcsResult.Companion.toKotlin as getVpcEndpointLinkedVpcsResultToKotlin

public object CrFunctions {
    /**
     * This data source provides the Cr Chains of the current Alibaba Cloud user.
     * For information about CR Chains and how to use it, see [What is Chain](https://www.alibabacloud.com/help/en/doc-detail/357821.html).
     * > **NOTE:** Available in v1.161.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cr.getChains({
     *     instanceId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const crChainId1 = ids.then(ids => ids.chains?.[0]?.id);
     * const nameRegex = alicloud.cr.getChains({
     *     instanceId: "example_value",
     *     nameRegex: "^my-Chain",
     * });
     * export const crChainId2 = nameRegex.then(nameRegex => nameRegex.chains?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cr.get_chains(instance_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("crChainId1", ids.chains[0].id)
     * name_regex = alicloud.cr.get_chains(instance_id="example_value",
     *     name_regex="^my-Chain")
     * pulumi.export("crChainId2", name_regex.chains[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CR.GetChains.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.CR.GetChains.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         NameRegex = "^my-Chain",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["crChainId1"] = ids&#46;Apply(getChainsResult => getChainsResult&#46;Chains[0]?.Id),
     *         ["crChainId2"] = nameRegex&#46;Apply(getChainsResult => getChainsResult&#46;Chains[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cr.GetChains(ctx, &cr.GetChainsArgs{
     * 			InstanceId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("crChainId1", ids.Chains[0].Id)
     * 		nameRegex, err := cr.GetChains(ctx, &cr.GetChainsArgs{
     * 			InstanceId: "example_value",
     * 			NameRegex:  pulumi.StringRef("^my-Chain"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("crChainId2", nameRegex.Chains[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cr.CrFunctions;
     * import com.pulumi.alicloud.cr.inputs.GetChainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CrFunctions.getChains(GetChainsArgs.builder()
     *             .instanceId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("crChainId1", ids.applyValue(getChainsResult -> getChainsResult.chains()[0].id()));
     *         final var nameRegex = CrFunctions.getChains(GetChainsArgs.builder()
     *             .instanceId("example_value")
     *             .nameRegex("^my-Chain")
     *             .build());
     *         ctx.export("crChainId2", nameRegex.applyValue(getChainsResult -> getChainsResult.chains()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cr:getChains
     *       Arguments:
     *         instanceId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cr:getChains
     *       Arguments:
     *         instanceId: example_value
     *         nameRegex: ^my-Chain
     * outputs:
     *   crChainId1: ${ids.chains[0].id}
     *   crChainId2: ${nameRegex.chains[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getChains.
     * @return A collection of values returned by getChains.
     */
    public suspend fun getChains(argument: GetChainsPlainArgs): GetChainsResult =
        getChainsResultToKotlin(getChainsPlain(argument.toJava()).await())

    /**
     * @see [getChains].
     * @param enableDetails
     * @param ids A list of Chain IDs.
     * @param instanceId The ID of CR Enterprise Edition instance.
     * @param nameRegex A regex string to filter results by Chain name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param repoName The name of CR Enterprise Edition repository.
     * @param repoNamespaceName The name of CR Enterprise Edition namespace.
     * @return A collection of values returned by getChains.
     */
    public suspend fun getChains(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        repoName: String? = null,
        repoNamespaceName: String? = null,
    ): GetChainsResult {
        val argument = GetChainsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            repoName = repoName,
            repoNamespaceName = repoNamespaceName,
        )
        return getChainsResultToKotlin(getChainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getChains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cr&#46;kotlin&#46;inputs&#46;GetChainsPlainArgs].
     * @return A collection of values returned by getChains.
     */
    public suspend fun getChains(argument: suspend GetChainsPlainArgsBuilder.() -> Unit): GetChainsResult {
        val builder = GetChainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChainsResultToKotlin(getChainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cr Chart Namespaces of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.149.0+.
     * @param argument A collection of arguments for invoking getChartNamespaces.
     * @return A collection of values returned by getChartNamespaces.
     */
    public suspend fun getChartNamespaces(argument: GetChartNamespacesPlainArgs): GetChartNamespacesResult =
        getChartNamespacesResultToKotlin(getChartNamespacesPlain(argument.toJava()).await())

    /**
     * @see [getChartNamespaces].
     * @param ids A list of matched Container Registry Enterprise Edition namespaces.
     * @param instanceId The ID of the Container Registry instance.
     * @param nameRegex A regex string to filter results by name space name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getChartNamespaces.
     */
    public suspend fun getChartNamespaces(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetChartNamespacesResult {
        val argument = GetChartNamespacesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getChartNamespacesResultToKotlin(getChartNamespacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getChartNamespaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cr&#46;kotlin&#46;inputs&#46;GetChartNamespacesPlainArgs].
     * @return A collection of values returned by getChartNamespaces.
     */
    public suspend fun getChartNamespaces(argument: suspend GetChartNamespacesPlainArgsBuilder.() -> Unit): GetChartNamespacesResult {
        val builder = GetChartNamespacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChartNamespacesResultToKotlin(getChartNamespacesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cr Chart Repositories of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.149.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cr.getChartRepositories({
     *     instanceId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const crChartRepositoryId1 = _default.ids[0];
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cr.get_chart_repositories(instance_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("crChartRepositoryId1", default["ids"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CR.GetChartRepositories.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["crChartRepositoryId1"] = @default&#46;Ids[0],
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cr.GetChartRepositories(ctx, &cr.GetChartRepositoriesArgs{
     * 			InstanceId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("crChartRepositoryId1", _default.Ids[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cr.CrFunctions;
     * import com.pulumi.alicloud.cr.inputs.GetChartRepositoriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CrFunctions.getChartRepositories(GetChartRepositoriesArgs.builder()
     *             .instanceId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("crChartRepositoryId1", default_.ids()[0]);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cr:getChartRepositories
     *       Arguments:
     *         instanceId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   crChartRepositoryId1: ${default.ids[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getChartRepositories.
     * @return A collection of values returned by getChartRepositories.
     */
    public suspend fun getChartRepositories(argument: GetChartRepositoriesPlainArgs): GetChartRepositoriesResult =
        getChartRepositoriesResultToKotlin(getChartRepositoriesPlain(argument.toJava()).await())

    /**
     * @see [getChartRepositories].
     * @param ids A list of matched Container Registry Enterprise Edition repositories.
     * @param instanceId InstanceId.
     * @param nameRegex A regex string to filter results by repository name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getChartRepositories.
     */
    public suspend fun getChartRepositories(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetChartRepositoriesResult {
        val argument = GetChartRepositoriesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getChartRepositoriesResultToKotlin(getChartRepositoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getChartRepositories].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cr&#46;kotlin&#46;inputs&#46;GetChartRepositoriesPlainArgs].
     * @return A collection of values returned by getChartRepositories.
     */
    public suspend fun getChartRepositories(argument: suspend GetChartRepositoriesPlainArgsBuilder.() -> Unit): GetChartRepositoriesResult {
        val builder = GetChartRepositoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChartRepositoriesResultToKotlin(getChartRepositoriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cr Endpoint Acl Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.139.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cr.getEndpointAclPolicies({
     *     instanceId: "example_value",
     *     endpointType: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const crEndpointAclPolicyId1 = ids.then(ids => ids.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cr.get_endpoint_acl_policies(instance_id="example_value",
     *     endpoint_type="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("crEndpointAclPolicyId1", ids.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CR.GetEndpointAclPolicies.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         EndpointType = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["crEndpointAclPolicyId1"] = ids&#46;Apply(getEndpointAclPoliciesResult => getEndpointAclPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cr.GetEndpointAclPolicies(ctx, &cr.GetEndpointAclPoliciesArgs{
     * 			InstanceId:   "example_value",
     * 			EndpointType: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("crEndpointAclPolicyId1", ids.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cr.CrFunctions;
     * import com.pulumi.alicloud.cr.inputs.GetEndpointAclPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CrFunctions.getEndpointAclPolicies(GetEndpointAclPoliciesArgs.builder()
     *             .instanceId("example_value")
     *             .endpointType("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("crEndpointAclPolicyId1", ids.applyValue(getEndpointAclPoliciesResult -> getEndpointAclPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cr:getEndpointAclPolicies
     *       Arguments:
     *         instanceId: example_value
     *         endpointType: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   crEndpointAclPolicyId1: ${ids.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEndpointAclPolicies.
     * @return A collection of values returned by getEndpointAclPolicies.
     */
    public suspend fun getEndpointAclPolicies(argument: GetEndpointAclPoliciesPlainArgs): GetEndpointAclPoliciesResult =
        getEndpointAclPoliciesResultToKotlin(getEndpointAclPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getEndpointAclPolicies].
     * @param endpointType The type of endpoint. Valid values: `internet`.
     * @param ids A list of Endpoint Acl Policy IDs.
     * @param instanceId The ID of the CR Instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getEndpointAclPolicies.
     */
    public suspend fun getEndpointAclPolicies(
        endpointType: String,
        ids: List<String>? = null,
        instanceId: String,
        outputFile: String? = null,
    ): GetEndpointAclPoliciesResult {
        val argument = GetEndpointAclPoliciesPlainArgs(
            endpointType = endpointType,
            ids = ids,
            instanceId = instanceId,
            outputFile = outputFile,
        )
        return getEndpointAclPoliciesResultToKotlin(getEndpointAclPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpointAclPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cr&#46;kotlin&#46;inputs&#46;GetEndpointAclPoliciesPlainArgs].
     * @return A collection of values returned by getEndpointAclPolicies.
     */
    public suspend fun getEndpointAclPolicies(argument: suspend GetEndpointAclPoliciesPlainArgsBuilder.() -> Unit): GetEndpointAclPoliciesResult {
        val builder = GetEndpointAclPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointAclPoliciesResultToKotlin(getEndpointAclPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the CR Endpoint Acl Service of the current Alibaba Cloud user.
     * For information about Event Bridge and how to use it, see [What is CR Endpoint Acl](https://www.alibabacloud.com/help/en/doc-detail/142246.htm).
     * > **NOTE:** Available in v1.139.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cr.getEndpointAclService({
     *     endpointType: "internet",
     *     enable: true,
     *     instanceId: "example_id",
     *     moduleName: "Registry",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cr.get_endpoint_acl_service(endpoint_type="internet",
     *     enable=True,
     *     instance_id="example_id",
     *     module_name="Registry")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.CR.GetEndpointAclService.Invoke(new()
     *     {
     *         EndpointType = "internet",
     *         Enable = true,
     *         InstanceId = "example_id",
     *         ModuleName = "Registry",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cr.GetEndpointAclService(ctx, &cr.GetEndpointAclServiceArgs{
     * 			EndpointType: "internet",
     * 			Enable:       true,
     * 			InstanceId:   "example_id",
     * 			ModuleName:   pulumi.StringRef("Registry"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cr.CrFunctions;
     * import com.pulumi.alicloud.cr.inputs.GetEndpointAclServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CrFunctions.getEndpointAclService(GetEndpointAclServiceArgs.builder()
     *             .endpointType("internet")
     *             .enable(true)
     *             .instanceId("example_id")
     *             .moduleName("Registry")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cr:getEndpointAclService
     *       Arguments:
     *         endpointType: internet
     *         enable: true
     *         instanceId: example_id
     *         moduleName: Registry
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEndpointAclService.
     * @return A collection of values returned by getEndpointAclService.
     */
    public suspend fun getEndpointAclService(argument: GetEndpointAclServicePlainArgs): GetEndpointAclServiceResult =
        getEndpointAclServiceResultToKotlin(getEndpointAclServicePlain(argument.toJava()).await())

    /**
     * @see [getEndpointAclService].
     * @param enable Whether to enable Acl Service, Setting the value to `true` to enable the acl service. Valid values: `true` and `false`.
     * @param endpointType The type of endpoint. Valid values: `internet`.
     * @param instanceId The ID of the CR Instance.
     * @param moduleName The ModuleName. Valid values: `Registry`.
     * > **NOTE:** After You enable access over the Internet, the Classless Inter-Domain Routing (CIDR) block `127.0.0.1/32` is automatically added to the whitelist.
     * > **NOTE:** You may want to allow all ECS instances to access the Container Registry Enterprise Edition instance over the Internet. To achieve this purpose, you can enable access over the Internet and delete all IP addresses from the whitelist for Internet access. After you perform the preceding operation, the Container Registry Enterprise Edition instance is completely exposed to the Internet and may be attacked.
     * @return A collection of values returned by getEndpointAclService.
     */
    public suspend fun getEndpointAclService(
        enable: Boolean,
        endpointType: String,
        instanceId: String,
        moduleName: String? = null,
    ): GetEndpointAclServiceResult {
        val argument = GetEndpointAclServicePlainArgs(
            enable = enable,
            endpointType = endpointType,
            instanceId = instanceId,
            moduleName = moduleName,
        )
        return getEndpointAclServiceResultToKotlin(getEndpointAclServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpointAclService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cr&#46;kotlin&#46;inputs&#46;GetEndpointAclServicePlainArgs].
     * @return A collection of values returned by getEndpointAclService.
     */
    public suspend fun getEndpointAclService(argument: suspend GetEndpointAclServicePlainArgsBuilder.() -> Unit): GetEndpointAclServiceResult {
        val builder = GetEndpointAclServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointAclServiceResultToKotlin(getEndpointAclServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Registry namespaces on Alibaba Cloud.
     * > **NOTE:** Available in v1.35.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const myNamespaces = alicloud.cr.getNamespaces({
     *     nameRegex: "my-namespace",
     *     outputFile: "my-namespace-json",
     * });
     * export const output = myNamespaces.then(myNamespaces => myNamespaces.namespaces);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * my_namespaces = alicloud.cr.get_namespaces(name_regex="my-namespace",
     *     output_file="my-namespace-json")
     * pulumi.export("output", my_namespaces.namespaces)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var myNamespaces = AliCloud.CR.GetNamespaces.Invoke(new()
     *     {
     *         NameRegex = "my-namespace",
     *         OutputFile = "my-namespace-json",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = myNamespaces.Apply(getNamespacesResult => getNamespacesResult.Namespaces),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		myNamespaces, err := cr.GetNamespaces(ctx, &cr.GetNamespacesArgs{
     * 			NameRegex:  pulumi.StringRef("my-namespace"),
     * 			OutputFile: pulumi.StringRef("my-namespace-json"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("output", myNamespaces.Namespaces)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cr.CrFunctions;
     * import com.pulumi.alicloud.cr.inputs.GetNamespacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var myNamespaces = CrFunctions.getNamespaces(GetNamespacesArgs.builder()
     *             .nameRegex("my-namespace")
     *             .outputFile("my-namespace-json")
     *             .build());
     *         ctx.export("output", myNamespaces.applyValue(getNamespacesResult -> getNamespacesResult.namespaces()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   myNamespaces:
     *     fn::invoke:
     *       Function: alicloud:cr:getNamespaces
     *       Arguments:
     *         nameRegex: my-namespace
     *         outputFile: my-namespace-json
     * outputs:
     *   output: ${myNamespaces.namespaces}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNamespaces.
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: GetNamespacesPlainArgs): GetNamespacesResult =
        getNamespacesResultToKotlin(getNamespacesPlain(argument.toJava()).await())

    /**
     * @see [getNamespaces].
     * @param nameRegex A regex string to filter results by namespace name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(nameRegex: String? = null, outputFile: String? = null): GetNamespacesResult {
        val argument = GetNamespacesPlainArgs(
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getNamespacesResultToKotlin(getNamespacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cr&#46;kotlin&#46;inputs&#46;GetNamespacesPlainArgs].
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: suspend GetNamespacesPlainArgsBuilder.() -> Unit): GetNamespacesResult {
        val builder = GetNamespacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespacesResultToKotlin(getNamespacesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Registry repositories on Alibaba Cloud.
     * > **NOTE:** Available in v1.35.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const myRepos = alicloud.cr.getRepos({
     *     nameRegex: "my-repos",
     *     outputFile: "my-repo-json",
     * });
     * export const output = myRepos.then(myRepos => myRepos.repos);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * my_repos = alicloud.cr.get_repos(name_regex="my-repos",
     *     output_file="my-repo-json")
     * pulumi.export("output", my_repos.repos)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var myRepos = AliCloud.CR.GetRepos.Invoke(new()
     *     {
     *         NameRegex = "my-repos",
     *         OutputFile = "my-repo-json",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = myRepos.Apply(getReposResult => getReposResult.Repos),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		myRepos, err := cr.GetRepos(ctx, &cr.GetReposArgs{
     * 			NameRegex:  pulumi.StringRef("my-repos"),
     * 			OutputFile: pulumi.StringRef("my-repo-json"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("output", myRepos.Repos)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cr.CrFunctions;
     * import com.pulumi.alicloud.cr.inputs.GetReposArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var myRepos = CrFunctions.getRepos(GetReposArgs.builder()
     *             .nameRegex("my-repos")
     *             .outputFile("my-repo-json")
     *             .build());
     *         ctx.export("output", myRepos.applyValue(getReposResult -> getReposResult.repos()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   myRepos:
     *     fn::invoke:
     *       Function: alicloud:cr:getRepos
     *       Arguments:
     *         nameRegex: my-repos
     *         outputFile: my-repo-json
     * outputs:
     *   output: ${myRepos.repos}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRepos.
     * @return A collection of values returned by getRepos.
     */
    public suspend fun getRepos(argument: GetReposPlainArgs): GetReposResult =
        getReposResultToKotlin(getReposPlain(argument.toJava()).await())

    /**
     * @see [getRepos].
     * @param enableDetails Boolean, false by default, only repository attributes are exported. Set to true if domain list and tags belong to this repository are needed. See `tags` in attributes.
     * @param nameRegex A regex string to filter results by repository name.
     * @param namespace Name of container registry namespace where the repositories are located in.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getRepos.
     */
    public suspend fun getRepos(
        enableDetails: Boolean? = null,
        nameRegex: String? = null,
        namespace: String? = null,
        outputFile: String? = null,
    ): GetReposResult {
        val argument = GetReposPlainArgs(
            enableDetails = enableDetails,
            nameRegex = nameRegex,
            namespace = namespace,
            outputFile = outputFile,
        )
        return getReposResultToKotlin(getReposPlain(argument.toJava()).await())
    }

    /**
     * @see [getRepos].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cr&#46;kotlin&#46;inputs&#46;GetReposPlainArgs].
     * @return A collection of values returned by getRepos.
     */
    public suspend fun getRepos(argument: suspend GetReposPlainArgsBuilder.() -> Unit): GetReposResult {
        val builder = GetReposPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReposResultToKotlin(getReposPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open Container Registry (CR) service automatically. If the service has been opened, it will return opened.
     * For information about Container Registry (CR) and how to use it, see [What is Container Registry (CR)](https://www.alibabacloud.com/help/en/doc-detail/142759.htm).
     * > **NOTE:** Available in v1.116.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.cr.getService({
     *     enable: "On",
     *     password: "1111aaaa",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.cr.get_service(enable="On",
     *     password="1111aaaa")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.CR.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *         Password = "1111aaaa",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cr.GetService(ctx, &cr.GetServiceArgs{
     * 			Enable:   pulumi.StringRef("On"),
     * 			Password: "1111aaaa",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cr.CrFunctions;
     * import com.pulumi.alicloud.cr.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = CrFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .password("1111aaaa")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:cr:getService
     *       Arguments:
     *         enable: On
     *         password: 1111aaaa
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * @param password The user password. The password must be 8 to 32 characters in length, and must contain at least two of the following character types: letters, special characters, and digits.
     * > **NOTE:** Setting `enable = "On"` to open the Container Registry (CR) service that means you have read and agreed the [Container Registry (CR) Terms of Service](https://help.aliyun.com/document_detail/190602.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null, password: String): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
            password = password,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cr&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the CR Vpc Endpoint Linked Vpcs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.199.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cr.getVpcEndpointLinkedVpcs({
     *     ids: ["example_id"],
     *     instanceId: "your_cr_instance_id",
     *     moduleName: "Registry",
     * });
     * export const alicloudCrVpcEndpointLinkedVpcsId1 = ids.then(ids => ids.vpcEndpointLinkedVpcs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cr.get_vpc_endpoint_linked_vpcs(ids=["example_id"],
     *     instance_id="your_cr_instance_id",
     *     module_name="Registry")
     * pulumi.export("alicloudCrVpcEndpointLinkedVpcsId1", ids.vpc_endpoint_linked_vpcs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.CR.GetVpcEndpointLinkedVpcs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         InstanceId = "your_cr_instance_id",
     *         ModuleName = "Registry",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCrVpcEndpointLinkedVpcsId1"] = ids&#46;Apply(getVpcEndpointLinkedVpcsResult => getVpcEndpointLinkedVpcsResult&#46;VpcEndpointLinkedVpcs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cr.GetVpcEndpointLinkedVpcs(ctx, &cr.GetVpcEndpointLinkedVpcsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			InstanceId: "your_cr_instance_id",
     * 			ModuleName: "Registry",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudCrVpcEndpointLinkedVpcsId1", ids.VpcEndpointLinkedVpcs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cr.CrFunctions;
     * import com.pulumi.alicloud.cr.inputs.GetVpcEndpointLinkedVpcsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CrFunctions.getVpcEndpointLinkedVpcs(GetVpcEndpointLinkedVpcsArgs.builder()
     *             .ids("example_id")
     *             .instanceId("your_cr_instance_id")
     *             .moduleName("Registry")
     *             .build());
     *         ctx.export("alicloudCrVpcEndpointLinkedVpcsId1", ids.applyValue(getVpcEndpointLinkedVpcsResult -> getVpcEndpointLinkedVpcsResult.vpcEndpointLinkedVpcs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cr:getVpcEndpointLinkedVpcs
     *       Arguments:
     *         ids:
     *           - example_id
     *         instanceId: your_cr_instance_id
     *         moduleName: Registry
     * outputs:
     *   alicloudCrVpcEndpointLinkedVpcsId1: ${ids.vpcEndpointLinkedVpcs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcEndpointLinkedVpcs.
     * @return A collection of values returned by getVpcEndpointLinkedVpcs.
     */
    public suspend fun getVpcEndpointLinkedVpcs(argument: GetVpcEndpointLinkedVpcsPlainArgs): GetVpcEndpointLinkedVpcsResult =
        getVpcEndpointLinkedVpcsResultToKotlin(getVpcEndpointLinkedVpcsPlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpointLinkedVpcs].
     * @param ids A list of CR Vpc Endpoint Linked Vpc IDs.
     * @param instanceId The ID of the instance.
     * @param moduleName The name of the module that you want to access. Valid Values:
     * - `Registry`: the image repository.
     * - `Chart`: a Helm chart.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Vpc Endpoint Linked Vpc. Valid Values: `CREATING`, `RUNNING`.
     * @return A collection of values returned by getVpcEndpointLinkedVpcs.
     */
    public suspend fun getVpcEndpointLinkedVpcs(
        ids: List<String>? = null,
        instanceId: String,
        moduleName: String,
        outputFile: String? = null,
        status: String? = null,
    ): GetVpcEndpointLinkedVpcsResult {
        val argument = GetVpcEndpointLinkedVpcsPlainArgs(
            ids = ids,
            instanceId = instanceId,
            moduleName = moduleName,
            outputFile = outputFile,
            status = status,
        )
        return getVpcEndpointLinkedVpcsResultToKotlin(getVpcEndpointLinkedVpcsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpointLinkedVpcs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cr&#46;kotlin&#46;inputs&#46;GetVpcEndpointLinkedVpcsPlainArgs].
     * @return A collection of values returned by getVpcEndpointLinkedVpcs.
     */
    public suspend fun getVpcEndpointLinkedVpcs(argument: suspend GetVpcEndpointLinkedVpcsPlainArgsBuilder.() -> Unit): GetVpcEndpointLinkedVpcsResult {
        val builder = GetVpcEndpointLinkedVpcsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointLinkedVpcsResultToKotlin(getVpcEndpointLinkedVpcsPlain(builtArgument.toJava()).await())
    }
}
