@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EndpointAclPolicy].
 */
@PulumiTagMarker
public class EndpointAclPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointAclPolicyArgs = EndpointAclPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointAclPolicyArgsBuilder.() -> Unit) {
        val builder = EndpointAclPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EndpointAclPolicy {
        val builtJavaResource = com.pulumi.alicloud.cr.EndpointAclPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EndpointAclPolicy(builtJavaResource)
    }
}

/**
 * Provides a CR Endpoint Acl Policy resource.
 * For information about CR Endpoint Acl Policy and how to use it, see [What is Endpoint Acl Policy](https://www.alibabacloud.com/help/doc-detail/145275.htm).
 * > **NOTE:** Available since v1.139.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const defaultRegistryEnterpriseInstance = new alicloud.cr.RegistryEnterpriseInstance("default", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const default = alicloud.cr.getEndpointAclServiceOutput({
 *     endpointType: "internet",
 *     enable: true,
 *     instanceId: defaultRegistryEnterpriseInstance.id,
 *     moduleName: "Registry",
 * });
 * const defaultEndpointAclPolicy = new alicloud.cr.EndpointAclPolicy("default", {
 *     instanceId: _default.apply(_default => _default.instanceId),
 *     entry: "192.168.1.0/24",
 *     description: name,
 *     moduleName: "Registry",
 *     endpointType: "internet",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("default",
 *     payment_type="Subscription",
 *     period=1,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * default = alicloud.cr.get_endpoint_acl_service_output(endpoint_type="internet",
 *     enable=True,
 *     instance_id=default_registry_enterprise_instance.id,
 *     module_name="Registry")
 * default_endpoint_acl_policy = alicloud.cr.EndpointAclPolicy("default",
 *     instance_id=default.instance_id,
 *     entry="192.168.1.0/24",
 *     description=name,
 *     module_name="Registry",
 *     endpoint_type="internet")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var defaultRegistryEnterpriseInstance = new AliCloud.CR.RegistryEnterpriseInstance("default", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var @default = AliCloud.CR.GetEndpointAclService.Invoke(new()
 *     {
 *         EndpointType = "internet",
 *         Enable = true,
 *         InstanceId = defaultRegistryEnterpriseInstance.Id,
 *         ModuleName = "Registry",
 *     });
 *     var defaultEndpointAclPolicy = new AliCloud.CR.EndpointAclPolicy("default", new()
 *     {
 *         InstanceId = @default.Apply(@default => @default.Apply(getEndpointAclServiceResult => getEndpointAclServiceResult.InstanceId)),
 *         Entry = "192.168.1.0/24",
 *         Description = name,
 *         ModuleName = "Registry",
 *         EndpointType = "internet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * cfg := config.New(ctx, "")
 * name := "tf-example";
 * if param := cfg.Get("name"); param != ""{
 * name = param
 * }
 * defaultRegistryEnterpriseInstance, err := cr.NewRegistryEnterpriseInstance(ctx, "default", &cr.RegistryEnterpriseInstanceArgs{
 * PaymentType: pulumi.String("Subscription"),
 * Period: pulumi.Int(1),
 * RenewalStatus: pulumi.String("ManualRenewal"),
 * InstanceType: pulumi.String("Advanced"),
 * InstanceName: pulumi.String(name),
 * })
 * if err != nil {
 * return err
 * }
 * _default := cr.GetEndpointAclServiceOutput(ctx, cr.GetEndpointAclServiceOutputArgs{
 * EndpointType: pulumi.String("internet"),
 * Enable: pulumi.Bool(true),
 * InstanceId: defaultRegistryEnterpriseInstance.ID(),
 * ModuleName: pulumi.String("Registry"),
 * }, nil);
 * _, err = cr.NewEndpointAclPolicy(ctx, "default", &cr.EndpointAclPolicyArgs{
 * InstanceId: pulumi.String(_default.ApplyT(func(_default cr.GetEndpointAclServiceResult) (*string, error) {
 * return &default.InstanceId, nil
 * }).(pulumi.StringPtrOutput)),
 * Entry: pulumi.String("192.168.1.0/24"),
 * Description: pulumi.String(name),
 * ModuleName: pulumi.String("Registry"),
 * EndpointType: pulumi.String("internet"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cr.CrFunctions;
 * import com.pulumi.alicloud.cr.inputs.GetEndpointAclServiceArgs;
 * import com.pulumi.alicloud.cr.EndpointAclPolicy;
 * import com.pulumi.alicloud.cr.EndpointAclPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var defaultRegistryEnterpriseInstance = new RegistryEnterpriseInstance("defaultRegistryEnterpriseInstance", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         final var default = CrFunctions.getEndpointAclService(GetEndpointAclServiceArgs.builder()
 *             .endpointType("internet")
 *             .enable(true)
 *             .instanceId(defaultRegistryEnterpriseInstance.id())
 *             .moduleName("Registry")
 *             .build());
 *         var defaultEndpointAclPolicy = new EndpointAclPolicy("defaultEndpointAclPolicy", EndpointAclPolicyArgs.builder()
 *             .instanceId(default_.applyValue(default_ -> default_.instanceId()))
 *             .entry("192.168.1.0/24")
 *             .description(name)
 *             .moduleName("Registry")
 *             .endpointType("internet")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultRegistryEnterpriseInstance:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     name: default
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   defaultEndpointAclPolicy:
 *     type: alicloud:cr:EndpointAclPolicy
 *     name: default
 *     properties:
 *       instanceId: ${default.instanceId}
 *       entry: 192.168.1.0/24
 *       description: ${name}
 *       moduleName: Registry
 *       endpointType: internet
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:cr:getEndpointAclService
 *       Arguments:
 *         endpointType: internet
 *         enable: true
 *         instanceId: ${defaultRegistryEnterpriseInstance.id}
 *         moduleName: Registry
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CR Endpoint Acl Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/endpointAclPolicy:EndpointAclPolicy example <instance_id>:<endpoint_type>:<entry>
 * ```
 */
public class EndpointAclPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.cr.EndpointAclPolicy,
) : KotlinCustomResource(javaResource, EndpointAclPolicyMapper) {
    /**
     * The description of the entry.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of endpoint. Valid values: `internet`.
     */
    public val endpointType: Output<String>
        get() = javaResource.endpointType().applyValue({ args0 -> args0 })

    /**
     * The IP segment that allowed to access.
     */
    public val entry: Output<String>
        get() = javaResource.entry().applyValue({ args0 -> args0 })

    /**
     * The ID of the CR Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The module that needs to set the access policy. Valid values: `Registry`.
     */
    public val moduleName: Output<String>?
        get() = javaResource.moduleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object EndpointAclPolicyMapper : ResourceMapper<EndpointAclPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cr.EndpointAclPolicy::class == javaResource::class

    override fun map(javaResource: Resource): EndpointAclPolicy = EndpointAclPolicy(
        javaResource as
            com.pulumi.alicloud.cr.EndpointAclPolicy,
    )
}

/**
 * @see [EndpointAclPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointAclPolicy].
 */
public suspend fun endpointAclPolicy(
    name: String,
    block: suspend EndpointAclPolicyResourceBuilder.() -> Unit,
): EndpointAclPolicy {
    val builder = EndpointAclPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointAclPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointAclPolicy(name: String): EndpointAclPolicy {
    val builder = EndpointAclPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
