@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.EndpointAclPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CR Endpoint Acl Policy resource.
 * For information about CR Endpoint Acl Policy and how to use it, see [What is Endpoint Acl Policy](https://www.alibabacloud.com/help/doc-detail/145275.htm).
 * > **NOTE:** Available since v1.139.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const defaultRegistryEnterpriseInstance = new alicloud.cr.RegistryEnterpriseInstance("default", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const default = alicloud.cr.getEndpointAclServiceOutput({
 *     endpointType: "internet",
 *     enable: true,
 *     instanceId: defaultRegistryEnterpriseInstance.id,
 *     moduleName: "Registry",
 * });
 * const defaultEndpointAclPolicy = new alicloud.cr.EndpointAclPolicy("default", {
 *     instanceId: _default.apply(_default => _default.instanceId),
 *     entry: "192.168.1.0/24",
 *     description: name,
 *     moduleName: "Registry",
 *     endpointType: "internet",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("default",
 *     payment_type="Subscription",
 *     period=1,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * default = alicloud.cr.get_endpoint_acl_service_output(endpoint_type="internet",
 *     enable=True,
 *     instance_id=default_registry_enterprise_instance.id,
 *     module_name="Registry")
 * default_endpoint_acl_policy = alicloud.cr.EndpointAclPolicy("default",
 *     instance_id=default.instance_id,
 *     entry="192.168.1.0/24",
 *     description=name,
 *     module_name="Registry",
 *     endpoint_type="internet")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var defaultRegistryEnterpriseInstance = new AliCloud.CR.RegistryEnterpriseInstance("default", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var @default = AliCloud.CR.GetEndpointAclService.Invoke(new()
 *     {
 *         EndpointType = "internet",
 *         Enable = true,
 *         InstanceId = defaultRegistryEnterpriseInstance.Id,
 *         ModuleName = "Registry",
 *     });
 *     var defaultEndpointAclPolicy = new AliCloud.CR.EndpointAclPolicy("default", new()
 *     {
 *         InstanceId = @default.Apply(@default => @default.Apply(getEndpointAclServiceResult => getEndpointAclServiceResult.InstanceId)),
 *         Entry = "192.168.1.0/24",
 *         Description = name,
 *         ModuleName = "Registry",
 *         EndpointType = "internet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * cfg := config.New(ctx, "")
 * name := "tf-example";
 * if param := cfg.Get("name"); param != ""{
 * name = param
 * }
 * defaultRegistryEnterpriseInstance, err := cr.NewRegistryEnterpriseInstance(ctx, "default", &cr.RegistryEnterpriseInstanceArgs{
 * PaymentType: pulumi.String("Subscription"),
 * Period: pulumi.Int(1),
 * RenewalStatus: pulumi.String("ManualRenewal"),
 * InstanceType: pulumi.String("Advanced"),
 * InstanceName: pulumi.String(name),
 * })
 * if err != nil {
 * return err
 * }
 * _default := cr.GetEndpointAclServiceOutput(ctx, cr.GetEndpointAclServiceOutputArgs{
 * EndpointType: pulumi.String("internet"),
 * Enable: pulumi.Bool(true),
 * InstanceId: defaultRegistryEnterpriseInstance.ID(),
 * ModuleName: pulumi.String("Registry"),
 * }, nil);
 * _, err = cr.NewEndpointAclPolicy(ctx, "default", &cr.EndpointAclPolicyArgs{
 * InstanceId: pulumi.String(_default.ApplyT(func(_default cr.GetEndpointAclServiceResult) (*string, error) {
 * return &default.InstanceId, nil
 * }).(pulumi.StringPtrOutput)),
 * Entry: pulumi.String("192.168.1.0/24"),
 * Description: pulumi.String(name),
 * ModuleName: pulumi.String("Registry"),
 * EndpointType: pulumi.String("internet"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cr.CrFunctions;
 * import com.pulumi.alicloud.cr.inputs.GetEndpointAclServiceArgs;
 * import com.pulumi.alicloud.cr.EndpointAclPolicy;
 * import com.pulumi.alicloud.cr.EndpointAclPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var defaultRegistryEnterpriseInstance = new RegistryEnterpriseInstance("defaultRegistryEnterpriseInstance", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         final var default = CrFunctions.getEndpointAclService(GetEndpointAclServiceArgs.builder()
 *             .endpointType("internet")
 *             .enable(true)
 *             .instanceId(defaultRegistryEnterpriseInstance.id())
 *             .moduleName("Registry")
 *             .build());
 *         var defaultEndpointAclPolicy = new EndpointAclPolicy("defaultEndpointAclPolicy", EndpointAclPolicyArgs.builder()
 *             .instanceId(default_.applyValue(default_ -> default_.instanceId()))
 *             .entry("192.168.1.0/24")
 *             .description(name)
 *             .moduleName("Registry")
 *             .endpointType("internet")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultRegistryEnterpriseInstance:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     name: default
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   defaultEndpointAclPolicy:
 *     type: alicloud:cr:EndpointAclPolicy
 *     name: default
 *     properties:
 *       instanceId: ${default.instanceId}
 *       entry: 192.168.1.0/24
 *       description: ${name}
 *       moduleName: Registry
 *       endpointType: internet
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:cr:getEndpointAclService
 *       Arguments:
 *         endpointType: internet
 *         enable: true
 *         instanceId: ${defaultRegistryEnterpriseInstance.id}
 *         moduleName: Registry
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CR Endpoint Acl Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/endpointAclPolicy:EndpointAclPolicy example <instance_id>:<endpoint_type>:<entry>
 * ```
 * @property description The description of the entry.
 * @property endpointType The type of endpoint. Valid values: `internet`.
 * @property entry The IP segment that allowed to access.
 * @property instanceId The ID of the CR Instance.
 * @property moduleName The module that needs to set the access policy. Valid values: `Registry`.
 */
public data class EndpointAclPolicyArgs(
    public val description: Output<String>? = null,
    public val endpointType: Output<String>? = null,
    public val entry: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val moduleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.EndpointAclPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.EndpointAclPolicyArgs =
        com.pulumi.alicloud.cr.EndpointAclPolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .entry(entry?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .moduleName(moduleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointAclPolicyArgs].
 */
@PulumiTagMarker
public class EndpointAclPolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var entry: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var moduleName: Output<String>? = null

    /**
     * @param value The description of the entry.
     */
    @JvmName("dmeqbhxhtmufnaat")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The type of endpoint. Valid values: `internet`.
     */
    @JvmName("muyepqcmgpkpkbpt")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The IP segment that allowed to access.
     */
    @JvmName("tosveunlhngsyxvd")
    public suspend fun entry(`value`: Output<String>) {
        this.entry = value
    }

    /**
     * @param value The ID of the CR Instance.
     */
    @JvmName("gnigegnujhuahxue")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The module that needs to set the access policy. Valid values: `Registry`.
     */
    @JvmName("ulnylgubqkqbdmxu")
    public suspend fun moduleName(`value`: Output<String>) {
        this.moduleName = value
    }

    /**
     * @param value The description of the entry.
     */
    @JvmName("arqxbpejpavduulm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The type of endpoint. Valid values: `internet`.
     */
    @JvmName("omejnhtpcxlxxqtx")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The IP segment that allowed to access.
     */
    @JvmName("ygvecglrwqhhxojt")
    public suspend fun entry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entry = mapped
    }

    /**
     * @param value The ID of the CR Instance.
     */
    @JvmName("ksqgypdarvdtmikv")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The module that needs to set the access policy. Valid values: `Registry`.
     */
    @JvmName("dnnussndeovsqidx")
    public suspend fun moduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moduleName = mapped
    }

    internal fun build(): EndpointAclPolicyArgs = EndpointAclPolicyArgs(
        description = description,
        endpointType = endpointType,
        entry = entry,
        instanceId = instanceId,
        moduleName = moduleName,
    )
}
