@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.NamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This resource will help you to manager Container Registry namespaces, see [What is Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createnamespace).
 * > **NOTE:** Available since v1.34.0.
 * > **NOTE:** You need to set your registry password in Container Registry console before use this resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = new alicloud.cr.Namespace("example", {
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.cr.Namespace("example",
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = new AliCloud.CR.Namespace("example", new()
 *     {
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cr.NewNamespace(ctx, "example", &cr.NamespaceArgs{
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.Namespace;
 * import com.pulumi.alicloud.cr.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:cr:Namespace
 *     properties:
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Container Registry namespace can be imported using the namespace, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/namespace:Namespace default my-namespace
 * ```
 * @property autoCreate Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
 * @property defaultVisibility `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
 * @property name Name of Container Registry namespace.
 */
public data class NamespaceArgs(
    public val autoCreate: Output<Boolean>? = null,
    public val defaultVisibility: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.NamespaceArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.NamespaceArgs =
        com.pulumi.alicloud.cr.NamespaceArgs.builder()
            .autoCreate(autoCreate?.applyValue({ args0 -> args0 }))
            .defaultVisibility(defaultVisibility?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var autoCreate: Output<Boolean>? = null

    private var defaultVisibility: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
     */
    @JvmName("hiblqyofqhipkvkb")
    public suspend fun autoCreate(`value`: Output<Boolean>) {
        this.autoCreate = value
    }

    /**
     * @param value `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
     */
    @JvmName("jclbufcygxxvfshn")
    public suspend fun defaultVisibility(`value`: Output<String>) {
        this.defaultVisibility = value
    }

    /**
     * @param value Name of Container Registry namespace.
     */
    @JvmName("qodpuhrtkfphhobp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Boolean, when it set to true, repositories are automatically created when pushing new images. If it set to false, you create repository for images before pushing.
     */
    @JvmName("auemfucinjqmhkgh")
    public suspend fun autoCreate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCreate = mapped
    }

    /**
     * @param value `PUBLIC` or `PRIVATE`, default repository visibility in this namespace.
     */
    @JvmName("trvhgabhucfxfong")
    public suspend fun defaultVisibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultVisibility = mapped
    }

    /**
     * @param value Name of Container Registry namespace.
     */
    @JvmName("petmyaeggkncuxdc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        autoCreate = autoCreate,
        defaultVisibility = defaultVisibility,
        name = name,
    )
}
