@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [RegistryEnterpriseInstance].
 */
@PulumiTagMarker
public class RegistryEnterpriseInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryEnterpriseInstanceArgs = RegistryEnterpriseInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryEnterpriseInstanceArgsBuilder.() -> Unit) {
        val builder = RegistryEnterpriseInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryEnterpriseInstance {
        val builtJavaResource =
            com.pulumi.alicloud.cr.RegistryEnterpriseInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryEnterpriseInstance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Container Registry Enterprise Edition instance can be imported using the `id`, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/registryEnterpriseInstance:RegistryEnterpriseInstance default cri-test
 * ```
 */
public class RegistryEnterpriseInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.cr.RegistryEnterpriseInstance,
) : KotlinCustomResource(javaResource, RegistryEnterpriseInstanceMapper) {
    /**
     * Time of Container Registry Enterprise Edition instance creation.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Name of your customized oss bucket. Use this bucket as instance storage if set.
     */
    public val customOssBucket: Output<String>?
        get() = javaResource.customOssBucket().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time of Container Registry Enterprise Edition instance expiration.
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * Name of Container Registry Enterprise Edition instance.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * Type of Container Registry Enterprise Edition instance. Valid values: `Basic`, `Standard`, `Advanced`. **NOTE:** International Account doesn't supports `Standard`.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The password of the Instance. The password is a string of 8 to 30 characters and must contain uppercase letters, lowercase letters, and numbers.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Subscription of Container Registry Enterprise Edition instance. Default value: `Subscription`. Valid values: `Subscription`.
     */
    public val paymentType: Output<String>?
        get() = javaResource.paymentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Service time of Container Registry Enterprise Edition instance. Default value: `12`. Valid values: `1`, `2`, `3`, `6`, `12`, `24`, `36`, `48`, `60`. Unit: `month`.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Renewal period of Container Registry Enterprise Edition instance. Unit: `month`.
     */
    public val renewPeriod: Output<Int>?
        get() = javaResource.renewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Renewal status of Container Registry Enterprise Edition instance. Valid values: `AutoRenewal`, `ManualRenewal`.
     */
    public val renewalStatus: Output<String>?
        get() = javaResource.renewalStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Status of Container Registry Enterprise Edition instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object RegistryEnterpriseInstanceMapper : ResourceMapper<RegistryEnterpriseInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cr.RegistryEnterpriseInstance::class == javaResource::class

    override fun map(javaResource: Resource): RegistryEnterpriseInstance =
        RegistryEnterpriseInstance(javaResource as com.pulumi.alicloud.cr.RegistryEnterpriseInstance)
}

/**
 * @see [RegistryEnterpriseInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryEnterpriseInstance].
 */
public suspend fun registryEnterpriseInstance(
    name: String,
    block: suspend RegistryEnterpriseInstanceResourceBuilder.() -> Unit,
): RegistryEnterpriseInstance {
    val builder = RegistryEnterpriseInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryEnterpriseInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryEnterpriseInstance(name: String): RegistryEnterpriseInstance {
    val builder = RegistryEnterpriseInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
