@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Container Registry Enterprise Edition instance can be imported using the `id`, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/registryEnterpriseInstance:RegistryEnterpriseInstance default cri-test
 * ```
 * @property customOssBucket Name of your customized oss bucket. Use this bucket as instance storage if set.
 * @property instanceName Name of Container Registry Enterprise Edition instance.
 * @property instanceType Type of Container Registry Enterprise Edition instance. Valid values: `Basic`, `Standard`, `Advanced`. **NOTE:** International Account doesn't supports `Standard`.
 * @property kmsEncryptedPassword An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property password The password of the Instance. The password is a string of 8 to 30 characters and must contain uppercase letters, lowercase letters, and numbers.
 * @property paymentType Subscription of Container Registry Enterprise Edition instance. Default value: `Subscription`. Valid values: `Subscription`.
 * @property period Service time of Container Registry Enterprise Edition instance. Default value: `12`. Valid values: `1`, `2`, `3`, `6`, `12`, `24`, `36`, `48`, `60`. Unit: `month`.
 * @property renewPeriod Renewal period of Container Registry Enterprise Edition instance. Unit: `month`.
 * @property renewalStatus Renewal status of Container Registry Enterprise Edition instance. Valid values: `AutoRenewal`, `ManualRenewal`.
 */
public data class RegistryEnterpriseInstanceArgs(
    public val customOssBucket: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val password: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs =
        com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs.builder()
            .customOssBucket(customOssBucket?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .password(password?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryEnterpriseInstanceArgs].
 */
@PulumiTagMarker
public class RegistryEnterpriseInstanceArgsBuilder internal constructor() {
    private var customOssBucket: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var password: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    /**
     * @param value Name of your customized oss bucket. Use this bucket as instance storage if set.
     */
    @JvmName("anvkkrlqfgamqjki")
    public suspend fun customOssBucket(`value`: Output<String>) {
        this.customOssBucket = value
    }

    /**
     * @param value Name of Container Registry Enterprise Edition instance.
     */
    @JvmName("ngjycwokqffmxjnf")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Type of Container Registry Enterprise Edition instance. Valid values: `Basic`, `Standard`, `Advanced`. **NOTE:** International Account doesn't supports `Standard`.
     */
    @JvmName("twyjdqiwquwnvtgl")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
     */
    @JvmName("gdgdakswegwfgwcj")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("rxfgcgvfyikunblb")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value The password of the Instance. The password is a string of 8 to 30 characters and must contain uppercase letters, lowercase letters, and numbers.
     */
    @JvmName("ykuswpwxnvtmcwdl")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Subscription of Container Registry Enterprise Edition instance. Default value: `Subscription`. Valid values: `Subscription`.
     */
    @JvmName("tmaihfmxaomqverv")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Service time of Container Registry Enterprise Edition instance. Default value: `12`. Valid values: `1`, `2`, `3`, `6`, `12`, `24`, `36`, `48`, `60`. Unit: `month`.
     */
    @JvmName("kgeyhgpygbugpuki")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Renewal period of Container Registry Enterprise Edition instance. Unit: `month`.
     */
    @JvmName("yingxspogftvitke")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value Renewal status of Container Registry Enterprise Edition instance. Valid values: `AutoRenewal`, `ManualRenewal`.
     */
    @JvmName("qteovlneniasusna")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value Name of your customized oss bucket. Use this bucket as instance storage if set.
     */
    @JvmName("cbqqljkkfuwllovi")
    public suspend fun customOssBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customOssBucket = mapped
    }

    /**
     * @param value Name of Container Registry Enterprise Edition instance.
     */
    @JvmName("qjtvjfmjwaswqgxk")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Type of Container Registry Enterprise Edition instance. Valid values: `Basic`, `Standard`, `Advanced`. **NOTE:** International Account doesn't supports `Standard`.
     */
    @JvmName("swgwgsvcckwjhqbm")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
     */
    @JvmName("tutmkoagucteyigj")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("tmweooybqdllugeo")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("bcvgytqquwhkitok")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value The password of the Instance. The password is a string of 8 to 30 characters and must contain uppercase letters, lowercase letters, and numbers.
     */
    @JvmName("bxnxdwbkebsvgryp")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Subscription of Container Registry Enterprise Edition instance. Default value: `Subscription`. Valid values: `Subscription`.
     */
    @JvmName("fmgxnhcuvwbumjur")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Service time of Container Registry Enterprise Edition instance. Default value: `12`. Valid values: `1`, `2`, `3`, `6`, `12`, `24`, `36`, `48`, `60`. Unit: `month`.
     */
    @JvmName("erpxffnttfvdqfvi")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Renewal period of Container Registry Enterprise Edition instance. Unit: `month`.
     */
    @JvmName("klsmdrkovajhetyt")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value Renewal status of Container Registry Enterprise Edition instance. Valid values: `AutoRenewal`, `ManualRenewal`.
     */
    @JvmName("jysgywlhnhydvhax")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    internal fun build(): RegistryEnterpriseInstanceArgs = RegistryEnterpriseInstanceArgs(
        customOssBucket = customOssBucket,
        instanceName = instanceName,
        instanceType = instanceType,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        password = password,
        paymentType = paymentType,
        period = period,
        renewPeriod = renewPeriod,
        renewalStatus = renewalStatus,
    )
}
