@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.kotlin.outputs.RepoDomainList
import com.pulumi.alicloud.cr.kotlin.outputs.RepoDomainList.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Repo].
 */
@PulumiTagMarker
public class RepoResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepoArgs = RepoArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepoArgsBuilder.() -> Unit) {
        val builder = RepoArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Repo {
        val builtJavaResource = com.pulumi.alicloud.cr.Repo(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Repo(builtJavaResource)
    }
}

/**
 * This resource will help you to manager Container Registry repositories, see [What is Repository](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createrepository).
 * > **NOTE:** Available since v1.35.0.
 * > **NOTE:** You need to set your registry password in Container Registry console before use this resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.cr.Namespace("example", {
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * const exampleRepo = new alicloud.cr.Repo("example", {
 *     namespace: example.name,
 *     name: name,
 *     summary: "this is summary of my new repo",
 *     repoType: "PUBLIC",
 *     detail: "this is a public repo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.cr.Namespace("example",
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * example_repo = alicloud.cr.Repo("example",
 *     namespace=example.name,
 *     name=name,
 *     summary="this is summary of my new repo",
 *     repo_type="PUBLIC",
 *     detail="this is a public repo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.CR.Namespace("example", new()
 *     {
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 *     var exampleRepo = new AliCloud.CR.Repo("example", new()
 *     {
 *         Namespace = example.Name,
 *         Name = name,
 *         Summary = "this is summary of my new repo",
 *         RepoType = "PUBLIC",
 *         Detail = "this is a public repo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := cr.NewNamespace(ctx, "example", &cr.NamespaceArgs{
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cr.NewRepo(ctx, "example", &cr.RepoArgs{
 * 			Namespace: example.Name,
 * 			Name:      pulumi.String(name),
 * 			Summary:   pulumi.String("this is summary of my new repo"),
 * 			RepoType:  pulumi.String("PUBLIC"),
 * 			Detail:    pulumi.String("this is a public repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.Namespace;
 * import com.pulumi.alicloud.cr.NamespaceArgs;
 * import com.pulumi.alicloud.cr.Repo;
 * import com.pulumi.alicloud.cr.RepoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *         var exampleRepo = new Repo("exampleRepo", RepoArgs.builder()
 *             .namespace(example.name())
 *             .name(name)
 *             .summary("this is summary of my new repo")
 *             .repoType("PUBLIC")
 *             .detail("this is a public repo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:cr:Namespace
 *     properties:
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 *   exampleRepo:
 *     type: alicloud:cr:Repo
 *     name: example
 *     properties:
 *       namespace: ${example.name}
 *       name: ${name}
 *       summary: this is summary of my new repo
 *       repoType: PUBLIC
 *       detail: this is a public repo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Container Registry repository can be imported using the `namespace/repository`, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/repo:Repo default `my-namespace/my-repo`
 * ```
 */
public class Repo internal constructor(
    override val javaResource: com.pulumi.alicloud.cr.Repo,
) : KotlinCustomResource(javaResource, RepoMapper) {
    /**
     * The repository specific information. MarkDown format is supported, and the length limit is 2000.
     */
    public val detail: Output<String>?
        get() = javaResource.detail().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The repository domain list.
     */
    public val domainList: Output<RepoDomainList>
        get() = javaResource.domainList().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Name of container registry repository.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Name of container registry namespace where repository is located.
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * `PUBLIC` or `PRIVATE`, repo's visibility.
     */
    public val repoType: Output<String>
        get() = javaResource.repoType().applyValue({ args0 -> args0 })

    /**
     * The repository general information. It can contain 1 to 80 characters.
     */
    public val summary: Output<String>
        get() = javaResource.summary().applyValue({ args0 -> args0 })
}

public object RepoMapper : ResourceMapper<Repo> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cr.Repo::class == javaResource::class

    override fun map(javaResource: Resource): Repo = Repo(javaResource as com.pulumi.alicloud.cr.Repo)
}

/**
 * @see [Repo].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Repo].
 */
public suspend fun repo(name: String, block: suspend RepoResourceBuilder.() -> Unit): Repo {
    val builder = RepoResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Repo].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repo(name: String): Repo {
    val builder = RepoResourceBuilder()
    builder.name(name)
    return builder.build()
}
