@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.RepoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This resource will help you to manager Container Registry repositories, see [What is Repository](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createrepository).
 * > **NOTE:** Available since v1.35.0.
 * > **NOTE:** You need to set your registry password in Container Registry console before use this resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.cr.Namespace("example", {
 *     name: name,
 *     autoCreate: false,
 *     defaultVisibility: "PUBLIC",
 * });
 * const exampleRepo = new alicloud.cr.Repo("example", {
 *     namespace: example.name,
 *     name: name,
 *     summary: "this is summary of my new repo",
 *     repoType: "PUBLIC",
 *     detail: "this is a public repo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.cr.Namespace("example",
 *     name=name,
 *     auto_create=False,
 *     default_visibility="PUBLIC")
 * example_repo = alicloud.cr.Repo("example",
 *     namespace=example.name,
 *     name=name,
 *     summary="this is summary of my new repo",
 *     repo_type="PUBLIC",
 *     detail="this is a public repo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.CR.Namespace("example", new()
 *     {
 *         Name = name,
 *         AutoCreate = false,
 *         DefaultVisibility = "PUBLIC",
 *     });
 *     var exampleRepo = new AliCloud.CR.Repo("example", new()
 *     {
 *         Namespace = example.Name,
 *         Name = name,
 *         Summary = "this is summary of my new repo",
 *         RepoType = "PUBLIC",
 *         Detail = "this is a public repo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := cr.NewNamespace(ctx, "example", &cr.NamespaceArgs{
 * 			Name:              pulumi.String(name),
 * 			AutoCreate:        pulumi.Bool(false),
 * 			DefaultVisibility: pulumi.String("PUBLIC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cr.NewRepo(ctx, "example", &cr.RepoArgs{
 * 			Namespace: example.Name,
 * 			Name:      pulumi.String(name),
 * 			Summary:   pulumi.String("this is summary of my new repo"),
 * 			RepoType:  pulumi.String("PUBLIC"),
 * 			Detail:    pulumi.String("this is a public repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cr.Namespace;
 * import com.pulumi.alicloud.cr.NamespaceArgs;
 * import com.pulumi.alicloud.cr.Repo;
 * import com.pulumi.alicloud.cr.RepoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .name(name)
 *             .autoCreate(false)
 *             .defaultVisibility("PUBLIC")
 *             .build());
 *         var exampleRepo = new Repo("exampleRepo", RepoArgs.builder()
 *             .namespace(example.name())
 *             .name(name)
 *             .summary("this is summary of my new repo")
 *             .repoType("PUBLIC")
 *             .detail("this is a public repo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:cr:Namespace
 *     properties:
 *       name: ${name}
 *       autoCreate: false
 *       defaultVisibility: PUBLIC
 *   exampleRepo:
 *     type: alicloud:cr:Repo
 *     name: example
 *     properties:
 *       namespace: ${example.name}
 *       name: ${name}
 *       summary: this is summary of my new repo
 *       repoType: PUBLIC
 *       detail: this is a public repo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Container Registry repository can be imported using the `namespace/repository`, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/repo:Repo default `my-namespace/my-repo`
 * ```
 * @property detail The repository specific information. MarkDown format is supported, and the length limit is 2000.
 * @property name Name of container registry repository.
 * @property namespace Name of container registry namespace where repository is located.
 * @property repoType `PUBLIC` or `PRIVATE`, repo's visibility.
 * @property summary The repository general information. It can contain 1 to 80 characters.
 */
public data class RepoArgs(
    public val detail: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val repoType: Output<String>? = null,
    public val summary: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.RepoArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.RepoArgs = com.pulumi.alicloud.cr.RepoArgs.builder()
        .detail(detail?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .namespace(namespace?.applyValue({ args0 -> args0 }))
        .repoType(repoType?.applyValue({ args0 -> args0 }))
        .summary(summary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepoArgs].
 */
@PulumiTagMarker
public class RepoArgsBuilder internal constructor() {
    private var detail: Output<String>? = null

    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    private var repoType: Output<String>? = null

    private var summary: Output<String>? = null

    /**
     * @param value The repository specific information. MarkDown format is supported, and the length limit is 2000.
     */
    @JvmName("wwepdoeobaffxbnm")
    public suspend fun detail(`value`: Output<String>) {
        this.detail = value
    }

    /**
     * @param value Name of container registry repository.
     */
    @JvmName("pkdacldjyklqydtx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of container registry namespace where repository is located.
     */
    @JvmName("hjkoleyfidvqsffv")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value `PUBLIC` or `PRIVATE`, repo's visibility.
     */
    @JvmName("crmfyqbewwpmflta")
    public suspend fun repoType(`value`: Output<String>) {
        this.repoType = value
    }

    /**
     * @param value The repository general information. It can contain 1 to 80 characters.
     */
    @JvmName("mmhhminuvsdhkgfa")
    public suspend fun summary(`value`: Output<String>) {
        this.summary = value
    }

    /**
     * @param value The repository specific information. MarkDown format is supported, and the length limit is 2000.
     */
    @JvmName("bninstbjelslntoc")
    public suspend fun detail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detail = mapped
    }

    /**
     * @param value Name of container registry repository.
     */
    @JvmName("gyqskibfmceigkfr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of container registry namespace where repository is located.
     */
    @JvmName("chuikccngpvrlvns")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value `PUBLIC` or `PRIVATE`, repo's visibility.
     */
    @JvmName("sriqctqcijlfpdiq")
    public suspend fun repoType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoType = mapped
    }

    /**
     * @param value The repository general information. It can contain 1 to 80 characters.
     */
    @JvmName("pcsrlnhubavualbt")
    public suspend fun summary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.summary = mapped
    }

    internal fun build(): RepoArgs = RepoArgs(
        detail = detail,
        name = name,
        namespace = namespace,
        repoType = repoType,
        summary = summary,
    )
}
